/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tridevmc.compound.config.CompoundModConfig;
import com.tridevmc.compound.config.ConfigField;
import com.tridevmc.compound.config.ConfigType;
import com.tridevmc.compound.config.ConfigValue;
import com.tridevmc.compound.core.reflect.WrappedField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundConfig<T> {
    static final Map<Object, CompoundConfig> KNOWN_CONFIGS = Maps.newHashMap();
    private static final Logger LOG = LogManager.getLogger((String)"CompoundConfig");
    private final CompoundModConfig modConfig;
    private final String modId;
    private final ModConfig.Type configType;
    private final ForgeConfigSpec forgeConfig;
    private final Class<T> configClass;
    private final T configInstance;
    private final ArrayList<ConfigField> fields = Lists.newArrayList();

    private CompoundConfig(@Nonnull Class<T> type, String modId, String configFile) throws IllegalAccessException, InstantiationException {
        this.modId = modId;
        this.configClass = type;
        this.configInstance = type.newInstance();
        this.configType = this.genConfigType();
        Pair configure = new ForgeConfigSpec.Builder().configure(this::loadConfig);
        this.forgeConfig = (ForgeConfigSpec)configure.getRight();
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        this.modConfig = new CompoundModConfig(this, modContainer, configFile);
        KNOWN_CONFIGS.put(this.configInstance, this);
    }

    @Nullable
    public static <C> C of(@Nonnull Class<C> type, @Nonnull String modId) {
        return CompoundConfig.of(type, modId, modId + ".toml");
    }

    @Nullable
    public static <C> C of(@Nonnull Class<C> type, @Nonnull String modId, @Nonnull String fileName) {
        CompoundConfig<C> cCompoundConfig = null;
        try {
            cCompoundConfig = new CompoundConfig<C>(type, modId, fileName);
            MinecraftForge.EVENT_BUS.register(cCompoundConfig);
        }
        catch (Exception e) {
            LOG.error("Failed to create compound config of type {}", (Object)type.getName());
            e.printStackTrace();
        }
        return cCompoundConfig == null ? null : (C)cCompoundConfig.configInstance;
    }

    private ModConfig.Type genConfigType() {
        if (this.configClass.isAnnotationPresent(ConfigType.class)) {
            ConfigType annotation = this.configClass.getAnnotation(ConfigType.class);
            return annotation.value();
        }
        return ModConfig.Type.COMMON;
    }

    private CompoundConfig loadConfig(ForgeConfigSpec.Builder builder) {
        if (this.fields.isEmpty()) {
            for (Field field : this.configClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigValue.class)) continue;
                WrappedField wrappedField = WrappedField.create(field);
                wrappedField.setAccessible(true);
                try {
                    ConfigField configField = new ConfigField(this, wrappedField);
                    this.fields.add(configField);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Failed to create ConfigField for field {}, caused by {}", (Object)wrappedField.getName(), (Object)e);
                }
            }
        }
        this.fields.forEach(f -> f.addToSpec(builder));
        return this;
    }

    protected void loadFields() {
        this.fields.forEach(ConfigField::loadField);
    }

    protected String getModId() {
        return this.modId;
    }

    protected ForgeConfigSpec getForgeConfig() {
        return this.forgeConfig;
    }

    protected Class<T> getConfigClass() {
        return this.configClass;
    }

    protected T getConfigInstance() {
        return this.configInstance;
    }

    protected ModConfig.Type getConfigType() {
        return this.configType;
    }

    @SubscribeEvent
    protected void onConfigLoading(ModConfig.Loading e) {
        LOG.info("Sup");
    }

    @SubscribeEvent
    protected void onConfigReloading(ModConfig.ConfigReloading e) {
        LOG.info("Bro");
    }
}

