/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.config;

import com.google.common.collect.Maps;
import com.tridevmc.compound.config.CompoundConfig;
import com.tridevmc.compound.config.ConfigValue;
import com.tridevmc.compound.config.RangedDouble;
import com.tridevmc.compound.config.RangedInt;
import com.tridevmc.compound.config.RangedLong;
import com.tridevmc.compound.core.reflect.WrappedField;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.ArrayUtils;

public class ConfigField {
    private static final Map<Class, EnumFieldType> TYPE_MAP = Maps.newHashMap();
    @Nonnull
    private final WrappedField field;
    private final Class fieldType;
    private final CompoundConfig config;
    private final EnumFieldType type;
    private final Object defaultValue;
    private final Object minValue;
    private final Object maxValue;
    private final String name;
    private final String comment;
    private final String langKey;
    private final boolean requiresWorldRestart;
    private final boolean isValueArray;
    private ForgeConfigSpec.ConfigValue value;

    protected ConfigField(CompoundConfig config, @Nonnull WrappedField field) {
        this.field = field;
        this.config = config;
        this.type = TYPE_MAP.computeIfAbsent(field.getType(), aClass -> {
            if (aClass.isEnum()) {
                return EnumFieldType.ENUM;
            }
            if (aClass.isArray() || List.class.isAssignableFrom((Class<?>)aClass)) {
                return EnumFieldType.LIST;
            }
            return EnumFieldType.OBJECT;
        });
        ConfigValue configValue = field.getAnnotation(ConfigValue.class);
        this.name = configValue.name().isEmpty() ? this.getField().getName() : configValue.name();
        this.comment = configValue.comment();
        this.langKey = configValue.langKey().isEmpty() ? config.getModId() + ".compoundconfig.gui.property." + this.getName() : configValue.langKey();
        this.requiresWorldRestart = configValue.requiresWorldRestart();
        this.isValueArray = field.getType().isArray() || List.class.isAssignableFrom(field.getType());
        Class fieldType = field.getType();
        if (fieldType.isArray()) {
            fieldType = fieldType.getComponentType();
        } else if (List.class.isAssignableFrom(fieldType)) {
            fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        this.fieldType = fieldType;
        this.defaultValue = this.genDefaultValue();
        Tuple<Object, Object> rangeData = this.getRangeData();
        this.minValue = rangeData.getA();
        this.maxValue = rangeData.getB();
    }

    private Tuple<Object, Object> getRangeData() {
        if (this.field.isAnnotationPresent(RangedInt.class)) {
            RangedInt annotation = this.field.getAnnotation(RangedInt.class);
            return new Tuple((Object)annotation.min(), (Object)annotation.max());
        }
        if (this.field.isAnnotationPresent(RangedDouble.class)) {
            RangedDouble annotation = this.field.getAnnotation(RangedDouble.class);
            return new Tuple((Object)annotation.min(), (Object)annotation.max());
        }
        if (this.fieldType.isAnnotationPresent(RangedLong.class)) {
            RangedLong annotation = this.field.getAnnotation(RangedLong.class);
            return new Tuple((Object)annotation.min(), (Object)annotation.max());
        }
        switch (this.type) {
            case INTEGER: {
                return new Tuple((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
            }
            case DOUBLE: {
                return new Tuple((Object)Double.MIN_VALUE, (Object)Double.MAX_VALUE);
            }
        }
        return new Tuple((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE);
    }

    private Object genDefaultValue() {
        Object value = this.field.getValue(this.config.getConfigInstance(), true);
        Class<?> fieldType = this.field.getType();
        if (fieldType.isArray()) {
            value = this.toObject(value);
        }
        return value;
    }

    public void addToSpec(ForgeConfigSpec.Builder builder) {
        builder = builder.comment(this.getComment()).translation(this.getLangKey());
        if (this.requiresWorldRestart()) {
            builder = builder.worldRestart();
        }
        switch (this.type) {
            case INTEGER: {
                this.value = builder.defineInRange(this.getName(), ((Integer)this.getDefaultValue()).intValue(), ((Integer)this.minValue).intValue(), ((Integer)this.maxValue).intValue());
                break;
            }
            case LONG: {
                this.value = builder.defineInRange(this.getName(), ((Long)this.getDefaultValue()).longValue(), ((Long)this.minValue).longValue(), ((Long)this.maxValue).longValue());
                break;
            }
            case DOUBLE: {
                this.value = builder.defineInRange(this.getName(), ((Double)this.getDefaultValue()).doubleValue(), ((Double)this.minValue).doubleValue(), ((Double)this.maxValue).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.value = builder.define(this.getName(), ((Boolean)this.getDefaultValue()).booleanValue());
                break;
            }
            case ENUM: {
                this.value = builder.defineEnum(this.getName(), (Enum)this.getDefaultValue());
                break;
            }
            case LIST: {
                this.value = builder.defineList(this.getName(), (List)this.getDefaultValue(), o -> true);
                break;
            }
            case OBJECT: {
                this.value = builder.define(this.getName(), this.getDefaultValue());
            }
        }
    }

    public void loadField() {
        if (this.isValueArray()) {
            this.setListValue((List)this.value.get());
        } else {
            this.getField().setValue(this.config.getConfigInstance(), this.value.get());
        }
    }

    private Object toPrimitive(Object values) {
        if (values == null) {
            return values;
        }
        Class<?> clazz = values.getClass().getComponentType();
        if (!clazz.isPrimitive()) {
            if (Boolean.class.equals(clazz)) {
                return ArrayUtils.toPrimitive((Boolean[])((Boolean[])values));
            }
            return ArrayUtils.toPrimitive((Object)values);
        }
        return values;
    }

    private Object toObject(Object values) {
        if (values == null) {
            return values;
        }
        Class<?> clazz = values.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (Integer.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((int[])((int[])values));
            }
            if (Double.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((double[])((double[])values));
            }
            if (Long.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((long[])((long[])values));
            }
            if (Boolean.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((boolean[])((boolean[])values));
            }
        }
        return Arrays.asList((Object[])values);
    }

    private void setListValue(List values) {
        Object configInstance = this.config.getConfigInstance();
        if (this.getField().getType().isArray()) {
            Object valueArray = Array.newInstance(this.getField().getType().getComponentType(), values.size());
            IntStream.range(0, values.size()).forEach(i -> Array.set(valueArray, i, values.get(i)));
            if (this.getField().getType().getComponentType().isPrimitive()) {
                this.getField().setValue(configInstance, this.toPrimitive(valueArray));
            } else {
                this.getField().setValue(configInstance, valueArray);
            }
        } else {
            List valueList = (List)this.getField().getValue(configInstance);
            valueList.clear();
            valueList.addAll(values);
        }
    }

    @Nonnull
    public WrappedField getField() {
        return this.field;
    }

    public boolean isValueArray() {
        return this.isValueArray;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public boolean requiresWorldRestart() {
        return this.requiresWorldRestart;
    }

    static {
        TYPE_MAP.put(Integer.class, EnumFieldType.INTEGER);
        TYPE_MAP.put(Integer.TYPE, EnumFieldType.INTEGER);
        TYPE_MAP.put(Long.class, EnumFieldType.LONG);
        TYPE_MAP.put(Long.TYPE, EnumFieldType.LONG);
        TYPE_MAP.put(Double.class, EnumFieldType.DOUBLE);
        TYPE_MAP.put(Double.TYPE, EnumFieldType.DOUBLE);
        TYPE_MAP.put(Boolean.class, EnumFieldType.BOOLEAN);
        TYPE_MAP.put(Boolean.TYPE, EnumFieldType.BOOLEAN);
    }

    private static enum EnumFieldType {
        INTEGER,
        LONG,
        DOUBLE,
        BOOLEAN,
        ENUM,
        OBJECT,
        LIST;

    }
}

