/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.apache.commons.lang3.reflect.FieldUtils;

public class WrappedField<T> {
    private Field field;
    private boolean isStatic;

    private WrappedField(Field field) {
        this.field = field;
        this.isStatic = Modifier.isStatic(field.getModifiers());
    }

    public static <T> WrappedField<T> create(Field field) {
        return new WrappedField<T>(field);
    }

    public static <T> WrappedField<T> create(Class clazz, String fieldName) {
        return new WrappedField<T>(FieldUtils.getField((Class)clazz, (String)fieldName, (boolean)true));
    }

    public static <T> WrappedField<T> create(Class clazz, String[] fieldNames) {
        Field f = null;
        for (String fieldName : fieldNames) {
            if (f != null) break;
            f = FieldUtils.getDeclaredField((Class)clazz, (String)fieldName, (boolean)true);
        }
        return new WrappedField<T>(f);
    }

    public T getStaticValue() {
        return this.getValue(null);
    }

    public void setStaticValue(T value) {
        this.setValue(null, value);
    }

    public T getValue(Object target) {
        return this.getValue(target, true);
    }

    public T getValue(Object target, boolean force) {
        try {
            if (this.isStatic) {
                return (T)FieldUtils.readStaticField((Field)this.field, (boolean)force);
            }
            return (T)FieldUtils.readField((Field)this.field, (Object)target, (boolean)force);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to read type of field %s", this.field.getName()), e);
        }
    }

    public void setValue(Object target, T value) {
        this.setValue(target, value, true);
    }

    public void setValue(Object target, T value, boolean force) {
        try {
            if (this.isStatic) {
                FieldUtils.writeStaticField((Field)this.field, value);
            } else {
                FieldUtils.writeField((Field)this.field, (Object)target, value, (boolean)force);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to write type of field %s", this.field.getName()), e);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.field.getAnnotationsByType(annotationClass);
    }

    public boolean isAccessible() {
        return this.field.isAccessible();
    }

    public void setAccessible(boolean b) {
        this.field.setAccessible(b);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }
}

