/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.gui.grid;

import com.tridevmc.compound.gui.MouseState;
import com.tridevmc.compound.gui.widget.WidgetBase;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;

public abstract class WidgetGrid
extends WidgetBase {
    protected final NonNullList<WidgetBase> widgets = NonNullList.create();
    protected final NonNullList<Tuple<Predicate<MouseState>, Consumer<MouseState>>> mousePressedCallbacks = NonNullList.create();

    public WidgetGrid(int top, int left, int width, int height) {
    }

    public void registerWidget(WidgetBase widget, int top, int left) {
        widget.setPosition(top, left);
        widget.onRegister(this.parent);
        this.widgets.add((Object)widget);
    }

    public void registerMousePressedCallback(Predicate<MouseState> predicate, Consumer<MouseState> callback) {
        this.mousePressedCallbacks.add((Object)new Tuple(predicate, callback));
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        for (WidgetBase widget : this.widgets) {
            widget.drawBackground(mouseX, mouseY);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        for (WidgetBase widget : this.widgets) {
            widget.drawForeground(mouseX, mouseY);
        }
    }

    public void handleMouseInput() {
        Minecraft mc = Minecraft.getInstance();
        MouseHelper mouseHelper = mc.mouseHelper;
        int normalizedX = (int)(mouseHelper.getMouseX() * (double)this.getWidth() / (double)Minecraft.getInstance().mainWindow.getWidth());
        int normalizedY = (int)(mouseHelper.getMouseY() * (double)this.getHeight() / (double)Minecraft.getInstance().mainWindow.getHeight());
        int buttonState = mouseHelper.isLeftDown() ? 0 : (mouseHelper.isRightDown() ? 1 : -1);
        MouseState state = new MouseState(normalizedX, normalizedY, buttonState);
        for (Tuple t : this.mousePressedCallbacks) {
            if (!((Predicate)t.getA()).test(state)) continue;
            ((Consumer)t.getB()).accept(state);
            return;
        }
    }
}

