/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.config;

import com.google.common.collect.Maps;
import com.tridevmc.compound.config.CompoundConfig;
import com.tridevmc.compound.config.ConfigValue;
import com.tridevmc.compound.config.IConfigFieldSerializer;
import com.tridevmc.compound.config.RangedDouble;
import com.tridevmc.compound.config.RangedInt;
import com.tridevmc.compound.config.RangedLong;
import com.tridevmc.compound.config.RegisteredValue;
import com.tridevmc.compound.core.reflect.WrappedField;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.ArrayUtils;

public class ConfigField<T> {
    private static final Map<Class<?>, EnumFieldType> TYPE_MAP = Maps.newHashMap();
    @Nonnull
    private final WrappedField<T> field;
    private final Class<T> fieldType;
    private final IConfigFieldSerializer<T> serializer;
    private final CompoundConfig<Object> config;
    private final EnumFieldType type;
    private final Object defaultValue;
    private final Object minValue;
    private final Object maxValue;
    private final ResourceLocation registryName;
    private final String name;
    private final String comment;
    private final String langKey;
    private final boolean requiresWorldRestart;
    private final boolean isValueArray;
    private ForgeConfigSpec.ConfigValue<T> specValue;
    private IForgeRegistry<T> registry;

    protected ConfigField(CompoundConfig<Object> config, @Nonnull WrappedField<T> field) {
        this.field = field;
        this.config = config;
        this.type = TYPE_MAP.computeIfAbsent(field.getType(), aClass -> {
            if (aClass.isEnum()) {
                return EnumFieldType.ENUM;
            }
            if (aClass.isArray() || List.class.isAssignableFrom((Class<?>)aClass)) {
                return EnumFieldType.LIST;
            }
            return EnumFieldType.OBJECT;
        });
        ConfigValue configValue = (ConfigValue)field.getAnnotation(ConfigValue.class);
        this.name = configValue.name().isEmpty() ? this.getField().getName() : configValue.name();
        this.comment = configValue.comment();
        this.langKey = configValue.langKey().isEmpty() ? config.getModId() + ".compoundconfig.gui.property." + this.getName() : configValue.langKey();
        this.requiresWorldRestart = configValue.requiresWorldRestart();
        this.isValueArray = field.getType().isArray() || List.class.isAssignableFrom(field.getType());
        Class fieldType = field.getType();
        if (fieldType.isArray()) {
            fieldType = fieldType.getComponentType();
        } else if (List.class.isAssignableFrom(fieldType)) {
            fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        this.fieldType = fieldType;
        this.serializer = config.getSerializerFor(this);
        this.defaultValue = this.genDefaultValue();
        Tuple<Object, Object> rangeData = this.generateRangeData();
        this.minValue = rangeData.getA();
        this.maxValue = rangeData.getB();
        this.registryName = this.generateRegistryName();
    }

    private Tuple<Object, Object> generateRangeData() {
        if (this.field.isAnnotationPresent(RangedInt.class)) {
            RangedInt annotation = (RangedInt)this.field.getAnnotation(RangedInt.class);
            return new Tuple((Object)annotation.min(), (Object)annotation.max());
        }
        if (this.field.isAnnotationPresent(RangedDouble.class)) {
            RangedDouble annotation = (RangedDouble)this.field.getAnnotation(RangedDouble.class);
            return new Tuple((Object)annotation.min(), (Object)annotation.max());
        }
        if (this.fieldType.isAnnotationPresent(RangedLong.class)) {
            RangedLong annotation = (RangedLong)this.field.getAnnotation(RangedLong.class);
            return new Tuple((Object)annotation.min(), (Object)annotation.max());
        }
        return switch (this.type) {
            case EnumFieldType.INTEGER -> new Tuple((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
            case EnumFieldType.DOUBLE -> new Tuple((Object)Double.MIN_VALUE, (Object)Double.MAX_VALUE);
            default -> new Tuple((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE);
        };
    }

    @Nullable
    private ResourceLocation generateRegistryName() {
        if (this.field.isAnnotationPresent(RegisteredValue.class)) {
            RegisteredValue annotation = (RegisteredValue)this.field.getAnnotation(RegisteredValue.class);
            return new ResourceLocation(annotation.value());
        }
        return null;
    }

    @Nullable
    protected IForgeRegistry<T> getRegistry() {
        if (this.registry == null && this.registryName != null) {
            this.registry = RegistryManager.ACTIVE.getRegistry(this.registryName);
        }
        return this.registry;
    }

    protected ResourceLocation getRegistryName() {
        return this.registryName;
    }

    private Object genDefaultValue() {
        List value = this.field.get(this.config.getConfigInstance(), true);
        Class fieldType = this.field.getType();
        if (fieldType.isArray()) {
            value = this.toObject(value);
        }
        if (this.serializer != null) {
            if (this.type == EnumFieldType.LIST) {
                List values = value;
                value = values.stream().map(o -> this.serializer.toString(this, o)).collect(Collectors.toList());
            } else {
                value = this.serializer.toString(this, value);
            }
        }
        return value;
    }

    public void addToSpec(ForgeConfigSpec.Builder builder) {
        builder = builder.comment(this.getComment()).translation(this.getLangKey());
        if (this.requiresWorldRestart()) {
            builder = builder.worldRestart();
        }
        switch (this.type) {
            case INTEGER: {
                this.specValue = builder.defineInRange(this.getName(), ((Integer)this.getDefaultValue()).intValue(), ((Integer)this.minValue).intValue(), ((Integer)this.maxValue).intValue());
                break;
            }
            case LONG: {
                this.specValue = builder.defineInRange(this.getName(), ((Long)this.getDefaultValue()).longValue(), ((Long)this.minValue).longValue(), ((Long)this.maxValue).longValue());
                break;
            }
            case DOUBLE: {
                this.specValue = builder.defineInRange(this.getName(), ((Double)this.getDefaultValue()).doubleValue(), ((Double)this.minValue).doubleValue(), ((Double)this.maxValue).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.specValue = builder.define(this.getName(), ((Boolean)this.getDefaultValue()).booleanValue());
                break;
            }
            case ENUM: {
                this.specValue = builder.defineEnum(this.getName(), (Enum)this.getDefaultValue());
                break;
            }
            case LIST: {
                this.specValue = builder.defineList(this.getName(), (List)this.getDefaultValue(), o -> true);
                break;
            }
            case OBJECT: {
                this.specValue = builder.define(this.getName(), this.getDefaultValue());
            }
        }
    }

    public void loadField() {
        if (this.isValueArray()) {
            List newValue = (List)this.getConfigSpecValue();
            if (this.serializer != null && newValue.stream().allMatch(o -> o instanceof String)) {
                newValue = newValue.stream().map(o -> this.serializer.fromString(this, (String)o)).collect(Collectors.toList());
            }
            this.setListValue(newValue);
        } else {
            Object newValue = this.getConfigSpecValue();
            if (this.serializer != null && newValue instanceof String) {
                newValue = this.serializer.fromString(this, (String)newValue);
            }
            this.getField().set(this.config.getConfigInstance(), newValue);
        }
    }

    private Object toPrimitive(Object values) {
        if (values == null) {
            return null;
        }
        Class<?> clazz = values.getClass().getComponentType();
        if (!clazz.isPrimitive()) {
            if (Boolean.class.equals(clazz)) {
                return ArrayUtils.toPrimitive((Boolean[])((Boolean[])values));
            }
            return ArrayUtils.toPrimitive((Object)values);
        }
        return values;
    }

    private Object toObject(Object values) {
        if (values == null) {
            return null;
        }
        Class<?> clazz = values.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (Integer.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((int[])((int[])values));
            }
            if (Double.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((double[])((double[])values));
            }
            if (Long.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((long[])((long[])values));
            }
            if (Boolean.TYPE.equals(clazz)) {
                values = ArrayUtils.toObject((boolean[])((boolean[])values));
            }
        }
        return Arrays.asList((Object[])values);
    }

    private void setListValue(List values) {
        Object configInstance = this.config.getConfigInstance();
        if (this.getField().getType().isArray()) {
            Object valueArray = Array.newInstance(this.getField().getType().getComponentType(), values.size());
            IntStream.range(0, values.size()).forEach(i -> Array.set(valueArray, i, values.get(i)));
            if (this.getField().getType().getComponentType().isPrimitive()) {
                this.getField().set(configInstance, this.toPrimitive(valueArray));
            } else {
                this.getField().set(configInstance, valueArray);
            }
        } else {
            List valueList = (List)this.getField().get(configInstance);
            valueList.clear();
            valueList.addAll(values);
        }
    }

    private <V> V getConfigSpecValue() {
        return (V)this.specValue.get();
    }

    @Nonnull
    public WrappedField<T> getField() {
        return this.field;
    }

    public boolean isValueArray() {
        return this.isValueArray;
    }

    public Class<T> getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public boolean requiresWorldRestart() {
        return this.requiresWorldRestart;
    }

    static {
        TYPE_MAP.put(Integer.class, EnumFieldType.INTEGER);
        TYPE_MAP.put(Integer.TYPE, EnumFieldType.INTEGER);
        TYPE_MAP.put(Long.class, EnumFieldType.LONG);
        TYPE_MAP.put(Long.TYPE, EnumFieldType.LONG);
        TYPE_MAP.put(Double.class, EnumFieldType.DOUBLE);
        TYPE_MAP.put(Double.TYPE, EnumFieldType.DOUBLE);
        TYPE_MAP.put(Boolean.class, EnumFieldType.BOOLEAN);
        TYPE_MAP.put(Boolean.TYPE, EnumFieldType.BOOLEAN);
    }

    private static enum EnumFieldType {
        INTEGER,
        LONG,
        DOUBLE,
        BOOLEAN,
        ENUM,
        OBJECT,
        LIST;

    }
}

