/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.config;

import com.tridevmc.compound.config.ConfigField;
import com.tridevmc.compound.config.IConfigFieldSerializer;
import net.minecraft.resources.ResourceLocation;

public class ForgeRegistryEntrySerializer<T>
implements IConfigFieldSerializer<T> {
    @Override
    public String toString(ConfigField<T> field, T value) {
        if (field.getRegistry() == null) {
            throw new NullPointerException("Unable to find valid registry with name " + field.getRegistryName().toString());
        }
        ResourceLocation key = field.getRegistry().getKey(value);
        if (key == null) {
            throw new NullPointerException("Unable to find valid key for value " + value.toString());
        }
        return key.toString();
    }

    @Override
    public T fromString(ConfigField<T> field, String value) {
        if (field.getRegistry() == null) {
            throw new NullPointerException("Unable to find valid registry with name " + field.getRegistryName().toString());
        }
        Object registeredValue = field.getRegistry().getValue(new ResourceLocation(value));
        if (registeredValue == null) {
            throw new NullPointerException("Unable to find valid value for key " + value);
        }
        return (T)registeredValue;
    }

    @Override
    public boolean accepts(ConfigField<T> field) {
        return field.getRegistryName() != null;
    }
}

