/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tridevmc.compound.config.CompoundModConfig;
import com.tridevmc.compound.config.ConfigField;
import com.tridevmc.compound.config.ConfigType;
import com.tridevmc.compound.config.ConfigValue;
import com.tridevmc.compound.config.ForgeRegistryEntrySerializer;
import com.tridevmc.compound.config.IConfigFieldSerializer;
import com.tridevmc.compound.config.IConfigObjectSerializer;
import com.tridevmc.compound.config.InternalRegistryEntrySerializer;
import com.tridevmc.compound.config.RegisteredConfigObjectSerializer;
import com.tridevmc.compound.core.reflect.WrappedField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundConfig<T> {
    static final Map<Object, CompoundConfig> KNOWN_CONFIGS = Maps.newHashMap();
    private static final Logger LOG = LogManager.getLogger((String)"CompoundConfig");
    private final CompoundModConfig modConfig;
    private final String modId;
    private final ModConfig.Type configType;
    private final ForgeConfigSpec forgeConfig;
    private final Set<IConfigFieldSerializer> objectSerializers;
    private final Class<T> configClass;
    private final T configInstance;
    private final ArrayList<ConfigField> fields = Lists.newArrayList();

    private CompoundConfig(@Nonnull Class<T> type, ModContainer container, String configFile) throws IllegalAccessException, InstantiationException {
        this.modId = container.getModId();
        this.configClass = type;
        this.configInstance = type.newInstance();
        this.configType = this.genConfigType();
        this.objectSerializers = Sets.newHashSet();
        this.objectSerializers.addAll(Arrays.stream(InternalRegistryEntrySerializer.DEFAULT_SERIALIZERS).toList());
        this.objectSerializers.add(new ForgeRegistryEntrySerializer());
        Pair configure = new ForgeConfigSpec.Builder().configure(this::loadConfig);
        this.forgeConfig = (ForgeConfigSpec)configure.getRight();
        if (container instanceof FMLModContainer) {
            ((FMLModContainer)container).getEventBus().register((Object)this);
        }
        this.modConfig = new CompoundModConfig(this, container, configFile);
        KNOWN_CONFIGS.put(this.configInstance, this);
    }

    @Nullable
    public static <C> C of(@Nonnull Class<C> type, @Nonnull ModContainer container) {
        return CompoundConfig.of(type, container, container.getModId() + ".toml");
    }

    @Nullable
    public static <C> C of(@Nonnull Class<C> type, @Nonnull ModContainer container, @Nonnull String fileName) {
        CompoundConfig<C> cCompoundConfig = null;
        try {
            cCompoundConfig = new CompoundConfig<C>(type, container, fileName);
        }
        catch (Exception e) {
            LOG.error("Failed to create compound config of type {}", (Object)type.getName());
            e.printStackTrace();
        }
        return cCompoundConfig == null ? null : (C)cCompoundConfig.configInstance;
    }

    private ModConfig.Type genConfigType() {
        if (this.configClass.isAnnotationPresent(ConfigType.class)) {
            ConfigType annotation = this.configClass.getAnnotation(ConfigType.class);
            return annotation.value();
        }
        return ModConfig.Type.COMMON;
    }

    private CompoundConfig loadConfig(ForgeConfigSpec.Builder builder) {
        if (this.objectSerializers.isEmpty()) {
            List modScanData = ModList.get().getAllScanData();
            ArrayList annotationData = Lists.newArrayList();
            String annotationName = RegisteredConfigObjectSerializer.class.getName();
            modScanData.forEach(m -> m.getAnnotations().stream().filter(a -> Objects.equals(a.annotationType().getClassName(), annotationName)).forEach(a -> {
                Map annotationInfo = a.annotationData();
                String modId = (String)annotationInfo.get("value");
                if (Objects.equals(modId, this.getModId())) {
                    annotationData.add(a);
                }
            }));
            this.objectSerializers.addAll(annotationData.stream().map(data -> {
                try {
                    return (IConfigObjectSerializer)Class.forName(data.targetType().name()).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(String.format("Failed to instantiate %s, is there an empty constructor?", data.memberName()), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Failed to instantiate %s, is there a public empty constructor?", data.memberName()), e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(String.format("Unable to find class: \"%s\" for registered marshaller.", data.memberName()), e);
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (this.fields.isEmpty()) {
            for (Field field : this.configClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigValue.class)) continue;
                WrappedField wrappedField = WrappedField.create((Field)field);
                wrappedField.setAccessible(true);
                try {
                    ConfigField configField = new ConfigField(this, wrappedField);
                    this.fields.add(configField);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Failed to create ConfigField for field {}, caused by {}", (Object)wrappedField.getName(), (Object)e);
                }
            }
        }
        this.fields.forEach(f -> f.addToSpec(builder));
        return this;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onConfigReloading(ModConfigEvent.Reloading e) {
        if (Objects.equals(e.getConfig(), (Object)this.modConfig)) {
            this.loadFields();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onConfigLoading(ModConfigEvent.Loading e) {
        if (Objects.equals(e.getConfig(), (Object)this.modConfig)) {
            this.loadFields();
        }
    }

    protected void loadFields() {
        this.fields.forEach(ConfigField::loadField);
    }

    protected String getModId() {
        return this.modId;
    }

    protected ForgeConfigSpec getForgeConfig() {
        return this.forgeConfig;
    }

    protected Class<T> getConfigClass() {
        return this.configClass;
    }

    protected T getConfigInstance() {
        return this.configInstance;
    }

    protected ModConfig.Type getConfigType() {
        return this.configType;
    }

    @Nullable
    protected <F> IConfigFieldSerializer<F> getSerializerFor(ConfigField<F> fieldType) {
        Optional<IConfigFieldSerializer> serializer = this.objectSerializers.stream().filter(s -> s.accepts(fieldType)).findFirst();
        return serializer.orElse(null);
    }
}

