/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.FieldUtils;

public class WrappedField<T> {
    private final Field field;
    private final boolean isStatic;

    private WrappedField(@Nonnull Field field) {
        this.field = field;
        this.isStatic = Modifier.isStatic(field.getModifiers());
    }

    public static <T> WrappedField<T> create(@Nonnull Field field) {
        return new WrappedField<T>(field);
    }

    @Nullable
    public static <T> WrappedField<T> create(Class<?> clazz, String fieldName) {
        Field f = FieldUtils.getField(clazz, (String)fieldName, (boolean)true);
        return f == null ? null : new WrappedField<T>(FieldUtils.getField(clazz, (String)fieldName, (boolean)true));
    }

    @Nullable
    public static <T> WrappedField<T> create(Class<?> clazz, String ... fieldNames) {
        Field f = null;
        for (String fieldName : fieldNames) {
            if (f != null) break;
            f = FieldUtils.getDeclaredField(clazz, (String)fieldName, (boolean)true);
        }
        return f == null ? null : new WrappedField<T>(f);
    }

    public T get() {
        return this.get(null);
    }

    public void set(T value) {
        this.set(null, value);
    }

    public T get(Object target) {
        return this.get(target, true);
    }

    public T get(Object target, boolean force) {
        try {
            if (this.isStatic) {
                return (T)FieldUtils.readStaticField((Field)this.field, (boolean)force);
            }
            return (T)FieldUtils.readField((Field)this.field, (Object)target, (boolean)force);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to read value of field %s", this.field.getName()), e);
        }
    }

    public void set(Object target, T value) {
        this.set(target, value, true);
    }

    public void set(Object target, T value, boolean force) {
        try {
            if (this.isStatic) {
                FieldUtils.writeStaticField((Field)this.field, value, (boolean)force);
            } else {
                FieldUtils.writeField((Field)this.field, (Object)target, value, (boolean)force);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to write type of field %s", this.field.getName()), e);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        return this.field.getAnnotationsByType(annotationClass);
    }

    public boolean isAccessible() {
        return this.field.isAccessible();
    }

    public void setAccessible(boolean b) {
        this.field.setAccessible(b);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }
}

