/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.apache.commons.lang3.reflect.MethodUtils;

public class WrappedMethod<T> {
    private Method method;

    private WrappedMethod(Method method) {
        this.method = method;
    }

    public static <T> WrappedMethod<T> create(Method method) {
        return new WrappedMethod<T>(method);
    }

    public static <T> WrappedMethod<T> create(Class clazz, String methodName, Class<?> ... parameterTypes) {
        return new WrappedMethod<T>(MethodUtils.getMatchingMethod((Class)clazz, (String)methodName, (Class[])parameterTypes));
    }

    public static <T> WrappedMethod<T> create(Class clazz, String methodName) {
        return new WrappedMethod<T>(MethodUtils.getMatchingMethod((Class)clazz, (String)methodName, (Class[])new Class[0]));
    }

    public static <T> WrappedMethod<T> create(Class clazz, String[] methodNames, Class<?> ... parameterTypes) {
        Method m = null;
        for (String methodName : methodNames) {
            if (m != null) break;
            m = MethodUtils.getMatchingMethod((Class)clazz, (String)methodName, (Class[])parameterTypes);
        }
        return new WrappedMethod<T>(m);
    }

    public static <T> WrappedMethod<T> create(Class clazz, String ... methodNames) {
        return WrappedMethod.create(clazz, methodNames, new Class[0]);
    }

    public T invoke() {
        return this.invoke(new Object[0]);
    }

    public T invoke(Object ... args) {
        return this.invoke((Object)null, true, args);
    }

    public T invoke(Object instance, boolean forceAccess, Object ... args) {
        try {
            if (forceAccess) {
                this.method.setAccessible(true);
            }
            return (T)this.method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to invoke method %s", this.getName()), e);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public String getName() {
        return this.method.getName();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.method.getAnnotation(clazz);
    }

    public Parameter[] getParameters() {
        return this.method.getParameters();
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        return this.method.getAnnotationsByType(clazz);
    }

    public boolean isAccessible() {
        return this.method.isAccessible();
    }

    public void setAccessible(boolean b) {
        this.method.setAccessible(b);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.method.isAnnotationPresent(clazz);
    }
}

