/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.gui;

import com.tridevmc.compound.gui.grid.WidgetGrid;
import com.tridevmc.compound.gui.grid.WidgetGridNormal;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CompoundGui
extends GuiScreen {
    protected final WidgetGrid grid;
    protected FontRenderer fontRenderer;

    public CompoundGui() {
        this.fontRenderer = Minecraft.getInstance().fontRenderer;
        this.grid = new WidgetGridNormal(0, 0, this.width, this.height);
        this.grid.onRegister(this);
    }

    public WidgetGrid getGrid() {
        return this.grid;
    }

    public void drawScreen(int mouseX, int mouseY) {
        MainWindow mainWindow = Minecraft.getInstance().mainWindow;
        this.grid.setWidth(mainWindow.getScaledWidth());
        this.grid.setHeight(mainWindow.getScaledHeight());
        if (this.fontRenderer == null) {
            return;
        }
        this.drawBackground(mouseX, mouseY);
        this.drawForeground(mouseX, mouseY);
    }

    protected void drawBackground(int mouseX, int mouseY) {
        this.grid.drawBackground(mouseX, mouseY);
    }

    protected void drawForeground(int mouseX, int mouseY) {
        this.grid.drawForeground(mouseX, mouseY);
    }

    public final FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public final void setFontRenderer(FontRenderer renderer) {
        this.fontRenderer = renderer;
    }

    public void handleMouseInput() {
        this.grid.handleMouseInput();
    }

    public void drawColoredRect(int x, int y, int width, int height, int color) {
        Gui.drawRect((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public void drawBeveledBoxes(int x, int y, int width, int height, int wide, int high) {
        for (int wY = 0; wY < high; ++wY) {
            for (int wX = 0; wX < wide; ++wX) {
                this.drawBeveledBox(x + width * wX, y + height * wY, width, height);
            }
        }
    }

    public void drawBeveledBox(int x, int y, int width, int height, int background, int topleft, int botright) {
        Gui.drawRect((int)x, (int)y, (int)(x + width), (int)(y + height), (int)background);
        Gui.drawRect((int)x, (int)y, (int)(x + (width - 1)), (int)(y + (height - 1)), (int)topleft);
        Gui.drawRect((int)(x + 1), (int)(y + 1), (int)(x + width), (int)(y + height), (int)botright);
        Gui.drawRect((int)(x + 1), (int)(y + 1), (int)(x + (width - 1)), (int)(y + (height - 1)), (int)background);
    }

    public void drawBeveledBox(int x, int y, int width, int height) {
        this.drawBeveledBox(x, y, width, height, -7631989, -13158601, -1);
    }
}

