/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.network.message;

import com.tridevmc.compound.network.core.CompoundNetwork;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class Message {
    private CompoundNetwork network;

    public abstract void handle(@Nullable PlayerEntity var1);

    @Nonnull
    public CompoundNetwork getNetwork() {
        if (this.network == null) {
            this.network = CompoundNetwork.getNetworkFor(this.getClass());
        }
        return this.network;
    }

    public void sendToAll() {
        this.sendToMatching(e -> true);
    }

    public void sendToMatching(@Nonnull Predicate<ServerPlayerEntity> playerPredicate) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        server.getPlayerList().getPlayers().stream().filter(playerPredicate).forEach(this::sendTo);
    }

    public void sendTo(@Nonnull ServerPlayerEntity player) {
        this.getNetwork().getNetworkChannel().sendTo((Object)this, player.connection.connection, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToAllAround(@Nonnull RegistryKey<World> dimension, @Nonnull BlockPos pos, double range) {
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), range, dimension);
        this.getNetwork().getNetworkChannel().send(PacketDistributor.NEAR.with(() -> target), (Object)this);
    }

    public void sendToAllTracking(@Nonnull Entity entity) {
        this.getNetwork().getNetworkChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)this);
    }

    public void sendToAllTracking(@Nonnull TileEntity tile) {
        this.sendToAllTracking(tile.getLevel().getChunkAt(tile.getBlockPos()));
    }

    public void sendToAllTracking(@Nonnull RegistryKey<World> dimension, @Nonnull BlockPos pos) {
        MinecraftServer currentServer = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        ServerWorld world = currentServer.getLevel(dimension);
        if (world != null) {
            Chunk chunk = world.getChunkAt(pos);
            this.sendToAllTracking(chunk);
        }
    }

    public void sendToAllTracking(@Nonnull Chunk chunk) {
        this.getNetwork().getNetworkChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)this);
    }

    public void sendToDimension(@Nonnull RegistryKey<World> dimension) {
        this.getNetwork().getNetworkChannel().send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)this);
    }

    public void sendToServer() {
        this.getNetwork().getNetworkChannel().sendToServer((Object)this);
    }
}

