/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.network.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tridevmc.compound.network.core.CompoundClientHandler;
import com.tridevmc.compound.network.core.CompoundServerHandler;
import com.tridevmc.compound.network.core.ICompoundNetworkHandler;
import com.tridevmc.compound.network.marshallers.DefaultMarshallers;
import com.tridevmc.compound.network.marshallers.EnumMarshallerPriority;
import com.tridevmc.compound.network.marshallers.Marshaller;
import com.tridevmc.compound.network.marshallers.MarshallerMetadata;
import com.tridevmc.compound.network.marshallers.RegisteredMarshaller;
import com.tridevmc.compound.network.marshallers.SetMarshaller;
import com.tridevmc.compound.network.message.Message;
import com.tridevmc.compound.network.message.MessageConcept;
import com.tridevmc.compound.network.message.MessageField;
import com.tridevmc.compound.network.message.RegisteredMessage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.objectweb.asm.Type;

public class CompoundNetwork {
    private static final Map<Class<? extends Message>, CompoundNetwork> NETWORKS = Maps.newHashMap();
    private final Logger logger;
    private final String name;
    private final SimpleChannel networkChannel;
    private Map<Class<? extends Message>, MessageConcept> messageConcepts;
    private Map<String, Marshaller> marshallers;
    private Map<Class, String> marshallerIds;
    private Map<LogicalSide, ICompoundNetworkHandler> handlers;

    private CompoundNetwork(ResourceLocation name, String version) {
        this.name = name.getPath();
        this.networkChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(v -> true).serverAcceptedVersions(v -> true).networkProtocolVersion(() -> version).simpleChannel();
        this.messageConcepts = Maps.newHashMap();
        this.marshallers = Maps.newHashMap();
        this.marshallerIds = Maps.newHashMap();
        this.handlers = Maps.newHashMap();
        this.handlers.put(LogicalSide.CLIENT, new CompoundClientHandler());
        this.handlers.put(LogicalSide.SERVER, new CompoundServerHandler());
        this.logger = LogManager.getLogger((String)("CompoundNetwork-" + name));
    }

    public static CompoundNetwork createNetwork(ModContainer container, String channel) {
        try {
            ArtifactVersion version = container.getModInfo().getVersion();
            CompoundNetwork network = new CompoundNetwork(new ResourceLocation(container.getModId(), channel), version.toString());
            network.loadDefaultMarshallers();
            network.discoverMarshallers();
            network.discoverMessages();
            return network;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create a CompoundNetwork with channel name %s", channel), e);
        }
    }

    public static CompoundNetwork getNetworkFor(Class<? extends Message> msg) {
        return NETWORKS.getOrDefault(msg, null);
    }

    private void loadDefaultMarshallers() {
        List<MarshallerMetadata> marshallerMetadata = DefaultMarshallers.genDefaultMarshallers();
        for (MarshallerMetadata marshallerMeta : marshallerMetadata) {
            String defaultId = marshallerMeta.ids[0];
            for (String id : marshallerMeta.ids) {
                this.marshallers.put(id, marshallerMeta.marshaller);
            }
            for (Class type : marshallerMeta.acceptedTypes) {
                this.marshallerIds.put(type, defaultId);
            }
        }
    }

    private void discoverMarshallers() {
        List<ModFileScanData.AnnotationData> applicableMarshallers = this.getAnnotationDataOfType(RegisteredMarshaller.class);
        applicableMarshallers.sort(Comparator.comparingInt(o -> {
            ModAnnotation.EnumHolder enumHolder = o.annotationData().getOrDefault("priority", null);
            EnumMarshallerPriority priority = enumHolder == null ? EnumMarshallerPriority.NORMAL : EnumMarshallerPriority.valueOf(enumHolder.getValue());
            return priority.getRank();
        }));
        for (ModFileScanData.AnnotationData applicableMarshaller : applicableMarshallers) {
            Marshaller marshaller = null;
            try {
                marshaller = (Marshaller)Class.forName(applicableMarshaller.memberName()).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Unable to find class: \"%s\" for registered marshaller.", applicableMarshaller.memberName()), e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format("Class: \"%s\" annotated with RegisteredMarshaller does not extend Marshaller.", applicableMarshaller.memberName()), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Failed to instantiate %s, is there a public empty constructor?", applicableMarshaller.memberName()), e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(String.format("Failed to instantiate %s", applicableMarshaller.memberName()), e);
            }
            Map annotationInfo = applicableMarshaller.annotationData();
            ArrayList ids = (ArrayList)annotationInfo.get("ids");
            ArrayList acceptedTypes = (ArrayList)annotationInfo.get("acceptedTypes");
            for (String id : ids) {
                this.marshallers.put(id, marshaller);
            }
            for (Type acceptedType : acceptedTypes) {
                try {
                    this.marshallerIds.put(Class.forName(acceptedType.getClassName()), (String)ids.get(0));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(String.format("Failed to find class to marshall with name %s", acceptedType.getClassName()), e);
                }
            }
        }
    }

    private void discoverMessages() {
        List<ModFileScanData.AnnotationData> applicableMessages = this.getAnnotationDataOfType(RegisteredMessage.class);
        int currentDiscriminator = 0;
        for (ModFileScanData.AnnotationData registeredMessage : applicableMessages) {
            Class<?> msgClass;
            Map annotationInfo = registeredMessage.annotationData();
            String networkChannel = (String)annotationInfo.get("channel");
            if (!Objects.equals(networkChannel, this.name)) continue;
            ModAnnotation.EnumHolder destinationHolder = (ModAnnotation.EnumHolder)annotationInfo.get("destination");
            LogicalSide destination = LogicalSide.valueOf((String)destinationHolder.getValue());
            try {
                msgClass = Class.forName(registeredMessage.memberName());
                msgClass.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Unable to find class: %s for registered message.", registeredMessage.memberName()), e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format("Class \"%s\" annotated with RegisteredMessage does not extend Message.", registeredMessage.memberName()), e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Class \"%s\" does not have an empty constructor available, this is required for networking.", registeredMessage.memberName()), e);
            }
            this.createConcept(msgClass, destination);
            this.registerMessage(msgClass, destination, currentDiscriminator);
            ++currentDiscriminator;
        }
    }

    private List<ModFileScanData.AnnotationData> getAnnotationDataOfType(Class annotation) {
        List modScanData = ModList.get().getAllScanData();
        ArrayList out = Lists.newArrayList();
        String annotationName = annotation.getName();
        modScanData.forEach(m -> m.getAnnotations().stream().filter(a -> Objects.equals(a.annotationType().getClassName(), annotationName)).forEach(a -> {
            Map annotationInfo = a.annotationData();
            String channel = (String)annotationInfo.get("channel");
            if (Objects.equals(channel, this.name)) {
                out.add(a);
            }
        }));
        return out;
    }

    private void createConcept(Class<? extends Message> msgClass, LogicalSide destination) {
        List usableFields = FieldUtils.getAllFieldsList(msgClass).stream().filter(field -> {
            Class<?> fieldDeclarer = field.getDeclaringClass();
            return !fieldDeclarer.equals(Message.class) && !fieldDeclarer.equals(Object.class);
        }).collect(Collectors.toList());
        List messageFields = usableFields.stream().map(field -> {
            String marshallerId = this.getMarshallerIdFor((Field)field);
            return this.marshallers.get(marshallerId).getMessageField((Field)field);
        }).collect(Collectors.toList());
        MessageConcept msgConcept = new MessageConcept(this, msgClass, new ArrayList<MessageField>(messageFields), destination);
        this.messageConcepts.put(msgClass, msgConcept);
    }

    private String getMarshallerIdFor(Field field) {
        if (field.isAnnotationPresent(SetMarshaller.class)) {
            return field.getAnnotation(SetMarshaller.class).value();
        }
        Class<?> fieldClass = field.getType();
        String marshallerId = this.marshallerIds.getOrDefault(fieldClass, null);
        if (marshallerId == null) {
            Optional<Class> matchingClass = this.marshallerIds.keySet().stream().filter(c -> c.isAssignableFrom(fieldClass)).findFirst();
            if (matchingClass.isPresent()) {
                marshallerId = this.marshallerIds.get(matchingClass.get());
            } else {
                throw new RuntimeException("Unable to find marshaller id for " + fieldClass.getName());
            }
        }
        return marshallerId;
    }

    private <M extends Message> void registerMessage(Class<M> msgClass, LogicalSide side, int discriminator) {
        ICompoundNetworkHandler handler = this.handlers.get(side);
        this.networkChannel.messageBuilder(msgClass, discriminator).encoder(this.getMsgConcept(msgClass)::toBytes).decoder(this.getMsgConcept(msgClass)::fromBytes).consumerMainThread(this.getMessageConsumer(handler)).add();
        NETWORKS.put(msgClass, this);
    }

    private <M extends Message> BiConsumer<M, Supplier<NetworkEvent.Context>> getMessageConsumer(ICompoundNetworkHandler handler) {
        return (m, ctx) -> handler.handle(m, (NetworkEvent.Context)ctx.get());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SimpleChannel getNetworkChannel() {
        return this.networkChannel;
    }

    public MessageConcept getMsgConcept(Message msg) {
        return this.messageConcepts.get(msg.getClass());
    }

    public MessageConcept getMsgConcept(Class<? extends Message> msgClass) {
        return this.messageConcepts.get(msgClass);
    }
}

