/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.network.marshallers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tridevmc.compound.network.marshallers.Marshaller;
import com.tridevmc.compound.network.marshallers.MarshallerMetadata;
import com.tridevmc.compound.network.message.MessageField;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class DefaultMarshallers {
    public static List<MarshallerMetadata> genDefaultMarshallers() {
        ArrayList out = Lists.newArrayList();
        out.add(new MarshallerMetadata(new String[]{"varint"}, new StaticSimpleMarshaller<Integer>(DefaultMarshallers::readVarInt, DefaultMarshallers::writeVarInt), new Class[]{Integer.class, Integer.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"varlong"}, new StaticSimpleMarshaller<Long>(DefaultMarshallers::readVarLong, DefaultMarshallers::writeVarLong), new Class[]{Long.class, Long.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"float"}, new SimpleMarshaller(ByteBuf::readFloat, ByteBuf::writeFloat), new Class[]{Float.class, Float.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"double"}, new SimpleMarshaller(ByteBuf::readDouble, ByteBuf::writeDouble), new Class[]{Double.class, Double.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"byte", "i8"}, new SimpleMarshaller(ByteBuf::readByte, ByteBuf::writeByte), new Class[]{Byte.class, Byte.TYPE, Integer.class, Integer.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"short", "i16"}, new SimpleMarshaller(ByteBuf::readShort, ByteBuf::writeShort), new Class[]{Short.class, Short.TYPE, Integer.class, Integer.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"long", "i64"}, new SimpleMarshaller(ByteBuf::readLong, ByteBuf::writeLong), new Class[]{Long.class, Long.TYPE, Integer.class, Integer.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"int", "i32"}, new SimpleMarshaller(ByteBuf::readInt, ByteBuf::writeInt), new Class[]{Integer.class, Integer.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"boolean"}, new SimpleMarshaller(ByteBuf::readBoolean, ByteBuf::writeBoolean), new Class[]{Boolean.class, Boolean.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"char"}, new SimpleMarshaller(ByteBuf::readChar, ByteBuf::writeChar), new Class[]{Character.class, Character.TYPE}));
        out.add(new MarshallerMetadata(new String[]{"Enum", "enum"}, new EnumMarshaller(), new Class[]{Enum.class}));
        out.add(new MarshallerMetadata(new String[]{"String"}, new StaticSimpleMarshaller<String>(DefaultMarshallers::readString, DefaultMarshallers::writeString), new Class[]{String.class}));
        out.add(new MarshallerMetadata(new String[]{"ItemStack"}, new StaticSimpleMarshaller<ItemStack>(DefaultMarshallers::readItemStack, DefaultMarshallers::writeItemStack), new Class[]{ItemStack.class}));
        out.add(new MarshallerMetadata(new String[]{"CompoundTag", "NBTTagCompound", "Tag", "NBT"}, new StaticSimpleMarshaller<CompoundTag>(DefaultMarshallers::readTag, DefaultMarshallers::writeTag), new Class[]{CompoundTag.class}));
        out.add(new MarshallerMetadata(new String[]{"BlockPos", "Vec3i"}, new StaticSimpleMarshaller<BlockPos>(DefaultMarshallers::readBlockPos, DefaultMarshallers::writeBlockPos), new Class[]{BlockPos.class, Vec3i.class}));
        return out;
    }

    private static void writeVarInt(ByteBuf buf, int toWrite) {
        new FriendlyByteBuf(buf).writeVarInt(toWrite);
    }

    private static int readVarInt(ByteBuf buf) {
        return new FriendlyByteBuf(buf).readVarInt();
    }

    private static void writeVarLong(ByteBuf buf, long toWrite) {
        new FriendlyByteBuf(buf).writeVarLong(toWrite);
    }

    private static long readVarLong(ByteBuf buf) {
        return new FriendlyByteBuf(buf).readVarLong();
    }

    private static void writeString(ByteBuf buf, String str) {
        new FriendlyByteBuf(buf).writeUtf(str);
    }

    private static String readString(ByteBuf buf) {
        return new FriendlyByteBuf(buf).readUtf(Short.MAX_VALUE);
    }

    private static void writeTag(ByteBuf buf, CompoundTag tag) {
        new FriendlyByteBuf(buf).writeNbt(tag);
    }

    private static CompoundTag readTag(ByteBuf buf) {
        return new FriendlyByteBuf(buf).readNbt();
    }

    private static void writeItemStack(ByteBuf buf, ItemStack stack) {
        new FriendlyByteBuf(buf).writeItemStack(stack, false);
    }

    private static ItemStack readItemStack(ByteBuf buf) {
        return new FriendlyByteBuf(buf).readItem();
    }

    private static BlockPos readBlockPos(ByteBuf buf) {
        return BlockPos.of((long)DefaultMarshallers.readVarLong(buf));
    }

    private static void writeBlockPos(ByteBuf buf, BlockPos value) {
        DefaultMarshallers.writeVarLong(buf, value.asLong());
    }

    private static class StaticSimpleMarshaller<T>
    extends Marshaller<T> {
        private final Function<ByteBuf, T> readMethod;
        private final BiConsumer<ByteBuf, T> writeMethod;

        public StaticSimpleMarshaller(Function<ByteBuf, T> readMethod, BiConsumer<ByteBuf, T> writeMethod) {
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            Objects.requireNonNull(readMethod);
            Objects.requireNonNull(writeMethod);
        }

        @Override
        public T readFrom(ByteBuf buf) {
            return (T)this.readMethod.apply((Object)buf);
        }

        @Override
        public void writeTo(ByteBuf buf, T obj) {
            this.writeMethod.accept(buf, (ByteBuf)obj);
        }
    }

    private static class SimpleMarshaller<T>
    extends Marshaller<T> {
        private final Function<ByteBuf, T> readMethod;
        private final Maps.EntryTransformer<ByteBuf, T, ByteBuf> writeMethod;

        public SimpleMarshaller(Function<ByteBuf, T> readMethod, Maps.EntryTransformer<ByteBuf, T, ByteBuf> writeMethod) {
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            Objects.requireNonNull(readMethod);
            Objects.requireNonNull(writeMethod);
        }

        @Override
        public T readFrom(ByteBuf buf) {
            return (T)this.readMethod.apply((Object)buf);
        }

        @Override
        public void writeTo(ByteBuf buf, T obj) {
            this.writeMethod.transformEntry((Object)buf, obj);
        }
    }

    private static class EnumMarshaller<T extends Enum>
    extends Marshaller<T> {
        private EnumMarshaller() {
        }

        @Override
        public T readFrom(MessageField field, ByteBuf buf) {
            return (T)((Enum)field.getType().getEnumConstants()[buf.readInt()]);
        }

        @Override
        public T readFrom(ByteBuf buf) {
            throw new RuntimeException("Unable to read enum with no field context.");
        }

        @Override
        public void writeTo(ByteBuf buf, T obj) {
            buf.writeInt(((Enum)obj).ordinal());
        }
    }
}

