/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.network.message;

import com.tridevmc.compound.network.core.CompoundNetwork;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class Message {
    private CompoundNetwork network;

    public abstract void handle(@Nullable Player var1);

    @Nonnull
    public CompoundNetwork getNetwork() {
        if (this.network == null) {
            this.network = CompoundNetwork.getNetworkFor(this.getClass());
        }
        return this.network;
    }

    public void sendToAll() {
        this.sendToMatching(e -> true);
    }

    public void sendToMatching(@Nonnull Predicate<ServerPlayer> playerPredicate) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        server.getPlayerList().getPlayers().stream().filter(playerPredicate).forEach(this::sendTo);
    }

    public void sendTo(@Nonnull ServerPlayer player) {
        this.getNetwork().getNetworkChannel().sendTo((Object)this, player.connection.connection, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToAllAround(@Nonnull ResourceKey<Level> dimension, @Nonnull BlockPos pos, double range) {
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), range, dimension);
        this.getNetwork().getNetworkChannel().send(PacketDistributor.NEAR.with(() -> target), (Object)this);
    }

    public void sendToAllTracking(@Nonnull Entity entity) {
        this.getNetwork().getNetworkChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)this);
    }

    public void sendToAllTracking(@Nonnull BlockEntity tile) {
        this.sendToAllTracking(tile.getLevel().getChunkAt(tile.getBlockPos()));
    }

    public void sendToAllTracking(@Nonnull ResourceKey<Level> dimension, @Nonnull BlockPos pos) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        ServerLevel level = currentServer.getLevel(dimension);
        if (level != null) {
            LevelChunk chunk = level.getChunkAt(pos);
            this.sendToAllTracking(chunk);
        }
    }

    public void sendToAllTracking(@Nonnull LevelChunk chunk) {
        this.getNetwork().getNetworkChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)this);
    }

    public void sendToDimension(@Nonnull ResourceKey<Level> dimension) {
        this.getNetwork().getNetworkChannel().send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)this);
    }

    public void sendToServer() {
        this.getNetwork().getNetworkChannel().sendToServer((Object)this);
    }
}

