/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.network.message;

import com.tridevmc.compound.core.reflect.WrappedField;
import com.tridevmc.compound.network.marshallers.Marshaller;
import com.tridevmc.compound.network.message.Message;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public class MessageField<T> {
    private final Marshaller<T> marshaller;
    private final WrappedField field;
    private final boolean isNullable;

    public MessageField(Marshaller<T> marshaller, Field field) {
        this.marshaller = marshaller;
        this.field = WrappedField.create((Field)field);
        this.isNullable = field.isAnnotationPresent(Nullable.class);
    }

    public void writeField(Message msg, ByteBuf target) {
        if (this.isNullable) {
            if (this.isNull(msg)) {
                target.writeBoolean(true);
                return;
            }
            target.writeBoolean(false);
        }
        if (this.field.getType().isArray()) {
            Object[] values = (Object[])this.getValue(msg);
            new FriendlyByteBuf(target).writeVarInt(values.length);
            for (Object value : values) {
                this.getMarshaller().writeTo(this, target, value);
            }
        } else {
            this.getMarshaller().writeTo(this, target, this.getValue(msg));
        }
    }

    public void readField(Message msg, ByteBuf source) {
        if (this.isNullable && source.readBoolean()) {
            return;
        }
        if (this.field.getType().isArray()) {
            int size = new FriendlyByteBuf(source).readVarInt();
            Object[] values = (Object[])Array.newInstance(this.field.getType(), size);
            for (int i = 0; i < size; ++i) {
                values[i] = this.getMarshaller().readFrom(this, source);
            }
            this.setValue(msg, values);
        } else {
            this.setValue(msg, this.getMarshaller().readFrom(this, source));
        }
    }

    public Class getType() {
        return this.getField().getType();
    }

    public void setValue(Message msg, Object value) {
        this.getField().set((Object)msg, value);
    }

    public Object getValue(Message msg) {
        return this.getField().get((Object)msg);
    }

    public Marshaller<T> getMarshaller() {
        return this.marshaller;
    }

    public WrappedField getField() {
        return this.field;
    }

    private boolean isNull(Message msg) {
        return this.getField().get((Object)msg) == null;
    }
}

