/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tridevmc.compound.ui.EnumUILayer;
import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.IInternalCompoundUI;
import com.tridevmc.compound.ui.element.IElement;
import com.tridevmc.compound.ui.listeners.ICharTypeListener;
import com.tridevmc.compound.ui.listeners.IKeyPressListener;
import com.tridevmc.compound.ui.listeners.IKeyReleaseListener;
import com.tridevmc.compound.ui.listeners.IMouseDraggedListener;
import com.tridevmc.compound.ui.listeners.IMousePressListener;
import com.tridevmc.compound.ui.listeners.IMouseReleaseListener;
import com.tridevmc.compound.ui.listeners.IMouseScrollListener;
import com.tridevmc.compound.ui.screen.CompoundScreenContext;
import com.tridevmc.compound.ui.screen.IScreenContext;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public abstract class CompoundUI
extends Screen
implements ICompoundUI,
IInternalCompoundUI {
    private PoseStack activeStack;
    private long ticks;
    private double mouseX;
    private double mouseY;
    private EnumUILayer currentLayer;
    private CompoundScreenContext screenContext = new CompoundScreenContext(this);
    private List<IElement> elements = Lists.newArrayList();
    private List<IKeyPressListener> keyPressListeners = Lists.newArrayList();
    private List<IKeyReleaseListener> keyReleaseListeners = Lists.newArrayList();
    private List<ICharTypeListener> charTypeListeners = Lists.newArrayList();
    private List<IMouseDraggedListener> mouseDragListeners = Lists.newArrayList();
    private List<IMousePressListener> mousePressListeners = Lists.newArrayList();
    private List<IMouseReleaseListener> mouseReleaseListeners = Lists.newArrayList();
    private List<IMouseScrollListener> mouseScrollListeners = Lists.newArrayList();

    public CompoundUI() {
        super((Component)new TextComponent(""));
        Minecraft mc = Minecraft.getInstance();
        this.init(mc, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
        this.initElements();
        this.elements.forEach(e -> e.initElement(this));
    }

    public void render(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.activeStack = stack;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        EnumUILayer[] enumUILayerArray = EnumUILayer.values();
        int n = enumUILayerArray.length;
        for (int i = 0; i < n; ++i) {
            EnumUILayer layer;
            this.currentLayer = layer = enumUILayerArray[i];
            this.elements.forEach(e -> e.drawLayer(this, layer));
        }
        super.render(stack, mouseX, mouseY, partialTicks);
    }

    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @Override
    public double getMouseX() {
        return this.mouseX;
    }

    @Override
    public double getMouseY() {
        return this.mouseY;
    }

    @Override
    public PoseStack getActiveStack() {
        return this.activeStack;
    }

    @Override
    public int getBlitOffset() {
        return super.getBlitOffset();
    }

    @Override
    public void setBlitOffset(int zLevel) {
        super.setBlitOffset(zLevel);
    }

    @Override
    public long getTicks() {
        return this.ticks;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Minecraft getMc() {
        return this.minecraft;
    }

    @Override
    public Screen asGuiScreen() {
        return this;
    }

    @Override
    public EnumUILayer getCurrentLayer() {
        return this.currentLayer;
    }

    public void renderTooltip(PoseStack stack, List<? extends FormattedCharSequence> lines, int x, int y, Font font) {
        super.renderTooltip(stack, lines, x, y, font);
    }

    public void renderComponentHoverEffect(PoseStack stack, Style style, int x, int y) {
        super.renderComponentHoverEffect(stack, style, x, y);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        this.keyPressListeners.forEach(l -> l.listen(this.screenContext, key, scanCode, modifiers));
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean keyReleased(int key, int scanCode, int modifiers) {
        this.keyReleaseListeners.forEach(l -> l.listen(this.screenContext, key, scanCode, modifiers));
        return super.keyReleased(key, scanCode, modifiers);
    }

    public boolean charTyped(char typedChar, int modifiers) {
        this.charTypeListeners.forEach(l -> l.listen(this.screenContext, typedChar, modifiers));
        return super.charTyped(typedChar, modifiers);
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.mousePressListeners.forEach(l -> l.listen(this.screenContext, x, y, button));
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseDragged(double x, double y, int button, double pX, double pY) {
        this.mouseDragListeners.forEach(l -> l.listen(this.screenContext, x, y, button, pX, pY));
        return super.mouseDragged(x, y, button, pX, pY);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.mouseReleaseListeners.forEach(l -> l.listen(this.screenContext, x, y, button));
        return super.mouseReleased(x, y, button);
    }

    public boolean mouseScrolled(double x, double y, double distance) {
        this.mouseScrollListeners.forEach(l -> l.listen(this.screenContext, x, y, distance));
        return super.mouseScrolled(x, y, distance);
    }

    @Override
    public IScreenContext getScreenContext() {
        return this.screenContext;
    }

    @Override
    public ImmutableList<IElement> getElements() {
        return ImmutableList.copyOf(this.elements);
    }

    @Override
    public void addElement(IElement element) {
        this.elements.add(element);
    }

    @Override
    public boolean removeElement(IElement element) {
        return this.elements.remove(element);
    }

    @Override
    public void addListener(IKeyPressListener listener) {
        this.keyPressListeners.add(listener);
    }

    @Override
    public void addListener(IKeyReleaseListener listener) {
        this.keyReleaseListeners.add(listener);
    }

    @Override
    public void addListener(ICharTypeListener listener) {
        this.charTypeListeners.add(listener);
    }

    @Override
    public void addListener(IMouseDraggedListener listener) {
        this.mouseDragListeners.add(listener);
    }

    @Override
    public void addListener(IMousePressListener listener) {
        this.mousePressListeners.add(listener);
    }

    @Override
    public void addListener(IMouseReleaseListener listener) {
        this.mouseReleaseListeners.add(listener);
    }

    @Override
    public void addListener(IMouseScrollListener listener) {
        this.mouseScrollListeners.add(listener);
    }
}

