/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui;

import com.google.common.base.MoreObjects;

public class Rect2F {
    private final float x;
    private final float y;
    private final float width;
    private final float height;

    public Rect2F(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect2F(Rect2F rect2F) {
        this.x = rect2F.x;
        this.y = rect2F.y;
        this.width = rect2F.width;
        this.height = rect2F.height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Rect2F offset(Rect2F by) {
        return new Rect2F(this.getX() + by.getX(), this.getY() + by.getY(), this.getWidth() + by.getWidth(), this.getHeight() + by.getHeight());
    }

    public Rect2F offsetPosition(float x, float y) {
        return this.offset(new Rect2F(x, y, 0.0f, 0.0f));
    }

    public Rect2F offsetSize(float width, float height) {
        return this.offset(new Rect2F(0.0f, 0.0f, width, height));
    }

    public Rect2F setPosition(float x, float y) {
        return new Rect2F(x, y, this.getWidth(), this.getHeight());
    }

    public Rect2F setSize(float width, float height) {
        return new Rect2F(this.getX(), this.getY(), width, height);
    }

    public boolean isPointInRect(double x, double y) {
        return x <= (double)(this.getX() + this.getWidth()) && x >= (double)this.getX() && y <= (double)(this.getY() + this.getHeight()) && y >= (double)this.getY();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("width", this.width).add("height", this.height).toString();
    }
}

