/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.container;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tridevmc.compound.core.reflect.WrappedField;
import com.tridevmc.compound.ui.EnumUILayer;
import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.IInternalCompoundUI;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.container.CompoundContainerMenu;
import com.tridevmc.compound.ui.element.IElement;
import com.tridevmc.compound.ui.element.container.ElementSlot;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.listeners.ICharTypeListener;
import com.tridevmc.compound.ui.listeners.IKeyPressListener;
import com.tridevmc.compound.ui.listeners.IKeyReleaseListener;
import com.tridevmc.compound.ui.listeners.IMouseDraggedListener;
import com.tridevmc.compound.ui.listeners.IMousePressListener;
import com.tridevmc.compound.ui.listeners.IMouseReleaseListener;
import com.tridevmc.compound.ui.listeners.IMouseScrollListener;
import com.tridevmc.compound.ui.screen.CompoundScreenContext;
import com.tridevmc.compound.ui.screen.IScreenContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class CompoundUIContainer<T extends CompoundContainerMenu>
extends AbstractContainerScreen<T>
implements ICompoundUI,
IInternalCompoundUI {
    private static final WrappedField<Slot> clickedSlot = WrappedField.create(AbstractContainerScreen.class, (String[])new String[]{"clickedSlot", "field_147005_v"});
    private static final WrappedField<Boolean> isSplittingStack = WrappedField.create(AbstractContainerScreen.class, (String[])new String[]{"isSplittingStack", "field_147004_w"});
    private static final WrappedField<ItemStack> draggingItem = WrappedField.create(AbstractContainerScreen.class, (String[])new String[]{"draggingItem", "field_147012_x"});
    private static final WrappedField<Integer> quickCraftingType = WrappedField.create(AbstractContainerScreen.class, (String[])new String[]{"quickCraftingType", "field_146987_F"});
    private PoseStack activeStack;
    private long ticks;
    private float mouseX;
    private float mouseY;
    private EnumUILayer currentLayer;
    private CompoundScreenContext screenContext = new CompoundScreenContext(this);
    private List<IElement> elements = Lists.newArrayList();
    private Map<Slot, ElementSlot> slotElements = Maps.newHashMap();
    private List<IKeyPressListener> keyPressListeners = Lists.newArrayList();
    private List<IKeyReleaseListener> keyReleaseListeners = Lists.newArrayList();
    private List<ICharTypeListener> charTypeListeners = Lists.newArrayList();
    private List<IMouseDraggedListener> mouseDragListeners = Lists.newArrayList();
    private List<IMousePressListener> mousePressListeners = Lists.newArrayList();
    private List<IMouseReleaseListener> mouseReleaseListeners = Lists.newArrayList();
    private List<IMouseScrollListener> mouseScrollListeners = Lists.newArrayList();

    public CompoundUIContainer(T container) {
        super(container, Minecraft.getInstance().player.getInventory(), (Component)new TextComponent(""));
        Minecraft mc = Minecraft.getInstance();
        this.init(mc, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
        this.initElements();
        this.elements.forEach(e -> e.initElement(this));
    }

    protected void renderBg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        this.currentLayer = EnumUILayer.BACKGROUND;
        this.elements.forEach(e -> e.drawLayer(this, EnumUILayer.BACKGROUND));
    }

    protected void renderLabels(PoseStack stack, int mouseX, int mouseY) {
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushPose();
        poseStack.translate((double)(-this.leftPos), (double)(-this.topPos), 0.0);
        this.currentLayer = EnumUILayer.FOREGROUND;
        this.elements.forEach(e -> e.drawLayer(this, EnumUILayer.FOREGROUND));
        this.currentLayer = EnumUILayer.OVERLAY;
        this.elements.forEach(e -> e.drawLayer(this, EnumUILayer.OVERLAY));
        poseStack.popPose();
    }

    public void render(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.activeStack = stack;
        this.renderBackground(stack);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.updateSlotStates();
        super.render(stack, mouseX, mouseY, partialTicks);
    }

    public void containerTick() {
        super.containerTick();
        ++this.ticks;
    }

    private void updateSlotStates() {
        Slot clickSlot = (Slot)clickedSlot.get((Object)this);
        ItemStack dragItem = (ItemStack)draggingItem.get((Object)this);
        Integer quickCraftType = (Integer)quickCraftingType.get((Object)this);
        Boolean splittingStack = (Boolean)isSplittingStack.get((Object)this);
        for (int i1 = 0; i1 < ((CompoundContainerMenu)this.getMenu()).slots.size(); ++i1) {
            Slot slot = (Slot)((CompoundContainerMenu)this.getMenu()).slots.get(i1);
            ElementSlot slotElement = this.slotElements.get(slot);
            if (slotElement == null) continue;
            ItemStack slotStack = slot.getItem();
            ItemStack playerStack = this.getMc().player.containerMenu.getCarried();
            if (slot == clickSlot && !dragItem.isEmpty() && splittingStack.booleanValue() && !slotStack.isEmpty()) {
                slotStack = slotStack.copy();
                slotStack.setCount(slotStack.getCount() / 2);
            } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !playerStack.isEmpty()) {
                if (this.quickCraftSlots.size() == 1) {
                    return;
                }
                if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)playerStack, (boolean)true) && ((CompoundContainerMenu)this.getMenu()).canDragTo(slot)) {
                    slotStack = playerStack.copy();
                    slotElement.setDrawUnderlay(true);
                    AbstractContainerMenu.getQuickCraftSlotCount((Set)this.quickCraftSlots, (int)quickCraftType, (ItemStack)slotStack, (int)(slot.getItem().isEmpty() ? 0 : slot.getItem().getCount()));
                    int size = Math.min(slotStack.getMaxStackSize(), slot.getMaxStackSize(slotStack));
                    if (slotStack.getCount() > size) {
                        slotElement.setDisplayString(ChatFormatting.YELLOW.toString() + size);
                        slotStack.setCount(size);
                    }
                }
            }
            slotElement.setDisplayStack(slotStack);
            slotElement.setDrawOverlay(slot.isActive() && slotElement.isMouseOverSlot(this.screenContext));
        }
    }

    public ElementSlot addSlotElement(ILayout layout, int slotIndex) {
        Slot slot = ((CompoundContainerMenu)this.getMenu()).getSlot(slotIndex);
        return this.addSlotElement(new Rect2F(slot.x, slot.y - Integer.MIN_VALUE, 18.0f, 18.0f), layout, slotIndex);
    }

    public ElementSlot addSlotElement(Rect2F dimensions, ILayout layout, int slotIndex) {
        Slot slot = ((CompoundContainerMenu)this.getMenu()).getSlot(slotIndex);
        ElementSlot element = new ElementSlot(dimensions, layout, slot);
        this.addElement(element);
        this.slotElements.put(slot, element);
        return element;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        Optional<Slot> matchingSlot = this.slotElements.keySet().stream().filter(s -> s.x == x && s.y == y).findFirst();
        return matchingSlot.map(slot -> this.slotElements.get(slot).getTransformedDimensions(this.screenContext).isPointInRect(mouseX, mouseY)).orElseGet(() -> super.isHovering(x, y, width, height, mouseX, mouseY));
    }

    @Override
    public double getMouseX() {
        return this.mouseX;
    }

    @Override
    public double getMouseY() {
        return this.mouseY;
    }

    @Override
    public PoseStack getActiveStack() {
        return this.activeStack;
    }

    @Override
    public int getBlitOffset() {
        return super.getBlitOffset();
    }

    @Override
    public void setBlitOffset(int blitOffset) {
        super.setBlitOffset(blitOffset);
    }

    @Override
    public long getTicks() {
        return this.ticks;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Minecraft getMc() {
        return this.minecraft;
    }

    @Override
    public Screen asGuiScreen() {
        return this;
    }

    @Override
    public EnumUILayer getCurrentLayer() {
        return this.currentLayer;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        this.keyPressListeners.forEach(l -> l.listen(this.screenContext, key, scanCode, modifiers));
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean keyReleased(int key, int scanCode, int modifiers) {
        this.keyReleaseListeners.forEach(l -> l.listen(this.screenContext, key, scanCode, modifiers));
        return super.keyReleased(key, scanCode, modifiers);
    }

    public boolean charTyped(char typedChar, int modifiers) {
        this.charTypeListeners.forEach(l -> l.listen(this.screenContext, typedChar, modifiers));
        return super.charTyped(typedChar, modifiers);
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.mousePressListeners.forEach(l -> l.listen(this.screenContext, x, y, button));
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseDragged(double x, double y, int button, double pX, double pY) {
        this.mouseDragListeners.forEach(l -> l.listen(this.screenContext, x, y, button, pX, pY));
        return super.mouseDragged(x, y, button, pX, pY);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.mouseReleaseListeners.forEach(l -> l.listen(this.screenContext, x, y, button));
        return super.mouseReleased(x, y, button);
    }

    public boolean mouseScrolled(double x, double y, double distance) {
        this.mouseScrollListeners.forEach(l -> l.listen(this.screenContext, x, y, distance));
        return super.mouseScrolled(x, y, distance);
    }

    @Override
    public IScreenContext getScreenContext() {
        return this.screenContext;
    }

    @Override
    public ImmutableList<IElement> getElements() {
        return ImmutableList.copyOf(this.elements);
    }

    @Override
    public void addElement(IElement element) {
        this.elements.add(element);
    }

    @Override
    public boolean removeElement(IElement element) {
        Optional<Map.Entry> entry = this.slotElements.entrySet().stream().filter(e -> ((ElementSlot)e.getValue()).equals(element)).findFirst();
        entry.ifPresent(e -> this.slotElements.remove(e.getKey()));
        return this.elements.remove(element);
    }

    @Override
    public void addListener(IKeyPressListener listener) {
        this.keyPressListeners.add(listener);
    }

    @Override
    public void addListener(IKeyReleaseListener listener) {
        this.keyReleaseListeners.add(listener);
    }

    @Override
    public void addListener(ICharTypeListener listener) {
        this.charTypeListeners.add(listener);
    }

    @Override
    public void addListener(IMouseDraggedListener listener) {
        this.mouseDragListeners.add(listener);
    }

    @Override
    public void addListener(IMousePressListener listener) {
        this.mousePressListeners.add(listener);
    }

    @Override
    public void addListener(IMouseReleaseListener listener) {
        this.mouseReleaseListeners.add(listener);
    }

    @Override
    public void addListener(IMouseScrollListener listener) {
        this.mouseScrollListeners.add(listener);
    }
}

