/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.element;

import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.UVData;
import com.tridevmc.compound.ui.element.Element;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.layout.LayoutNone;
import com.tridevmc.compound.ui.screen.IScreenContext;
import net.minecraft.resources.ResourceLocation;

public class ElementBox
extends Element {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/inventory.png");

    public ElementBox(Rect2F dimensions) {
        this(dimensions, new LayoutNone());
    }

    public ElementBox(Rect2F dimensions, ILayout layout) {
        super(dimensions, layout);
    }

    @Override
    public void drawBackground(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        screen.bindTexture(TEXTURE);
        this.drawCorners(ui);
        this.drawConnectingLines(ui);
        this.drawMiddle(ui);
    }

    private void drawCorners(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        float xOff = rect.getX();
        float yOff = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        screen.drawTexturedRect(new Rect2F(xOff, yOff, 4.0f, 4.0f), new UVData(0.0f, 0.0f));
        screen.drawTexturedRect(new Rect2F(xOff + width - 4.0f, yOff, 4.0f, 4.0f), new UVData(172.0f, 0.0f));
        screen.drawTexturedRect(new Rect2F(xOff, yOff + height - 4.0f, 4.0f, 4.0f), new UVData(0.0f, 162.0f));
        screen.drawTexturedRect(new Rect2F(xOff + width - 4.0f, yOff + height - 4.0f, 4.0f, 4.0f), new UVData(172.0f, 162.0f));
    }

    private void drawConnectingLines(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        float xOff = rect.getX();
        float yOff = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        screen.drawTexturedRect(new Rect2F(xOff, yOff + 4.0f, 4.0f, height - 8.0f), new UVData(0.0f, 4.0f), new UVData(4.0f, 5.0f));
        screen.drawTexturedRect(new Rect2F(xOff + width - 4.0f, yOff + 4.0f, 4.0f, height - 8.0f), new UVData(172.0f, 4.0f), new UVData(176.0f, 5.0f));
        screen.drawTexturedRect(new Rect2F(xOff + 4.0f, yOff, width - 8.0f, 4.0f), new UVData(4.0f, 0.0f), new UVData(5.0f, 4.0f));
        screen.drawTexturedRect(new Rect2F(xOff + 4.0f, yOff + height - 4.0f, width - 8.0f, 4.0f), new UVData(4.0f, 162.0f), new UVData(5.0f, 166.0f));
    }

    private void drawMiddle(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        float xOff = rect.getX();
        float yOff = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        screen.drawTexturedRect(new Rect2F(xOff + 4.0f, yOff + 4.0f, width - 8.0f, height - 8.0f), new UVData(4.0f, 4.0f), new UVData(5.0f, 5.0f));
    }
}

