/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.element.Element;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.screen.IScreenContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public class ElementLabel
extends Element {
    private final Font fontRenderer;
    private Component text;
    private boolean drawShadow;
    private boolean wrapText;
    private boolean autoSize;
    private int maxWidth;
    private int maxHeight;
    private List<FormattedCharSequence> lines = Lists.newArrayList();
    private int longestLineWidth;

    public ElementLabel(Rect2F dimensions, ILayout layout, Font fontRenderer, boolean drawShadow, boolean wrapText, boolean autoSize, int maxWidth, int maxHeight) {
        super(dimensions, layout);
        this.fontRenderer = fontRenderer;
        this.drawShadow = drawShadow;
        this.wrapText = wrapText;
        this.autoSize = autoSize;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public ElementLabel(Rect2F dimensions, ILayout layout, Font fontRenderer, boolean drawShadow, boolean wrapText, boolean autoSize) {
        this(dimensions, layout, fontRenderer, drawShadow, wrapText, autoSize, -1, -1);
    }

    public ElementLabel(Rect2F dimensions, ILayout layout, Font fontRenderer) {
        this(dimensions, layout, fontRenderer, true, true, true, -1, -1);
    }

    public ElementLabel(Rect2F dimensions, ILayout layout) {
        this(dimensions, layout, Minecraft.getInstance().font);
    }

    @Override
    public void drawForeground(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        PoseStack activeStack = screen.getActiveStack();
        Rect2F dimensions = this.getTransformedDimensions(screen);
        double nextYLevel = dimensions.getY();
        for (FormattedCharSequence line : this.lines) {
            Objects.requireNonNull(this.fontRenderer);
            if (nextYLevel + 9.0 > (double)(dimensions.getY() + dimensions.getHeight())) {
                float f = dimensions.getY();
                float f2 = dimensions.getHeight();
                Objects.requireNonNull(this.fontRenderer);
                nextYLevel = Math.min(f, f2 - 9.0f);
            }
            if (this.drawShadow) {
                screen.drawFormattedCharSequenceWithShadow(activeStack, line, dimensions.getX(), (float)nextYLevel);
            } else {
                screen.drawFormattedCharSequence(activeStack, line, dimensions.getX(), (float)nextYLevel);
            }
            Objects.requireNonNull(this.fontRenderer);
            nextYLevel += 9.0;
        }
    }

    private void resize() {
        if (this.autoSize) {
            int newWidth = Math.min(this.getMaxWidth(), this.longestLineWidth);
            int n = this.getMaxHeight();
            int n2 = this.lines.size();
            Objects.requireNonNull(this.fontRenderer);
            int newHeight = Math.min(n, n2 * (9 + 2));
            this.setDimensions(this.getDimensions().setSize(newWidth, newHeight));
        }
    }

    public void setText(String text) {
        this.setText((Component)new TextComponent(text));
    }

    public void setText(Component text) {
        this.text = text;
        this.lines = this.wrapText ? ComponentRenderUtils.wrapComponents((FormattedText)this.text, (int)this.getMaxWidth(), (Font)this.fontRenderer) : Lists.newArrayList((Object[])new FormattedCharSequence[]{text.getVisualOrderText()});
        this.longestLineWidth = this.lines.stream().mapToInt(arg_0 -> ((Font)this.fontRenderer).width(arg_0)).max().orElseGet(this::getMaxWidth);
        this.resize();
    }

    public Component getText() {
        return this.text;
    }

    private int getMaxWidth() {
        if (this.autoSize) {
            return this.maxWidth == -1 ? Integer.MAX_VALUE : this.maxWidth;
        }
        return (int)this.getDimensions().getWidth();
    }

    private int getMaxHeight() {
        if (this.autoSize) {
            return this.maxHeight == -1 ? Integer.MAX_VALUE : this.maxHeight;
        }
        return (int)this.getDimensions().getHeight();
    }
}

