/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.element;

import com.tridevmc.compound.ui.EnumUILayer;
import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.screen.IScreenContext;
import javax.annotation.Nonnull;

public interface IElement {
    default public void drawLayer(ICompoundUI ui, EnumUILayer layer) {
        switch (layer) {
            case BACKGROUND: {
                this.drawBackground(ui);
                break;
            }
            case FOREGROUND: {
                this.drawForeground(ui);
                break;
            }
            case OVERLAY: {
                this.drawOverlay(ui);
            }
        }
    }

    default public void drawBackground(ICompoundUI ui) {
    }

    default public void drawForeground(ICompoundUI ui) {
    }

    default public void drawOverlay(ICompoundUI ui) {
    }

    default public void initElement(ICompoundUI ui) {
    }

    default public void tick(ICompoundUI ui) {
    }

    @Nonnull
    public Rect2F getDimensions();

    public void setDimensions(@Nonnull Rect2F var1);

    @Nonnull
    public ILayout getLayout();

    public void setLayout(@Nonnull ILayout var1);

    default public Rect2F getTransformedDimensions(IScreenContext screen) {
        return this.getLayout().getTransformedRect(screen, this, this.getDimensions());
    }
}

