/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.element.button;

import com.google.common.collect.Lists;
import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.UVData;
import com.tridevmc.compound.ui.element.Element;
import com.tridevmc.compound.ui.element.button.IButtonHoverListener;
import com.tridevmc.compound.ui.element.button.IButtonPressListener;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.screen.IScreenContext;
import java.util.List;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ElementButton
extends Element {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private boolean isEnabled = true;
    private boolean isVisible = true;
    private boolean isHovered = false;
    private List<IButtonPressListener> pressListeners = Lists.newArrayList();
    private List<IButtonHoverListener> hoverListeners = Lists.newArrayList();

    public ElementButton(Rect2F dimensions, ILayout layout) {
        super(dimensions, layout);
    }

    @Override
    public void drawBackground(ICompoundUI ui) {
        double mouseY;
        double mouseX;
        IScreenContext screen = ui.getScreenContext();
        Rect2F dimensions = this.getTransformedDimensions(screen);
        if (dimensions.isPointInRect(mouseX = screen.getMouseX(), mouseY = screen.getMouseY()) && this.canPress()) {
            if (!this.isHovered) {
                this.hoverListeners.forEach(l -> l.onButtonHover(mouseX, mouseY, true));
                this.isHovered = true;
            }
        } else if (this.isHovered) {
            this.hoverListeners.forEach(l -> l.onButtonHover(mouseX, mouseY, false));
            this.isHovered = false;
        }
        if (this.isVisible()) {
            screen.bindTexture(TEXTURE);
            this.drawCorners(ui);
            this.drawConnectingLines(ui);
            this.drawMiddle(ui);
        }
    }

    @Override
    public void initElement(ICompoundUI ui) {
        ui.addListener(this::onMousePress);
    }

    private UVData getUvData() {
        boolean uvX = false;
        int uvY = 46;
        if (this.isEnabled()) {
            uvY += 20;
            if (this.isHovered) {
                uvY += 20;
            }
        }
        return new UVData((float)uvX, uvY);
    }

    private void drawCorners(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        UVData uvData = this.getUvData();
        float xOff = rect.getX();
        float yOff = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        screen.drawTexturedRect(new Rect2F(xOff, yOff, 3.0f, 3.0f), uvData);
        screen.drawTexturedRect(new Rect2F(xOff + width - 3.0f, yOff, 3.0f, 3.0f), new UVData(uvData.getU() + 197.0f, uvData.getV()));
        screen.drawTexturedRect(new Rect2F(xOff, yOff + height - 3.0f, 3.0f, 3.0f), new UVData(uvData.getU(), uvData.getV() + 17.0f));
        screen.drawTexturedRect(new Rect2F(xOff + width - 3.0f, yOff + height - 3.0f, 3.0f, 3.0f), new UVData(uvData.getU() + 197.0f, uvData.getV() + 17.0f));
    }

    private void drawConnectingLines(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        UVData uvData = this.getUvData();
        float xOff = rect.getX();
        float yOff = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        screen.drawTiledTexturedRect(new Rect2F(xOff, yOff + 3.0f, 3.0f, height - 6.0f), new UVData(uvData.getU(), uvData.getV() + 3.0f), new UVData(uvData.getU() + 3.0f, uvData.getV() + 17.0f));
        screen.drawTiledTexturedRect(new Rect2F(xOff + width - 3.0f, yOff + 3.0f, 3.0f, height - 6.0f), new UVData(uvData.getU() + 197.0f, uvData.getV() + 3.0f), new UVData(uvData.getU() + 200.0f, uvData.getV() + 17.0f));
        screen.drawTiledTexturedRect(new Rect2F(xOff + 3.0f, yOff, width - 6.0f, 3.0f), new UVData(uvData.getU() + 3.0f, uvData.getV()), new UVData(uvData.getU() + 197.0f, uvData.getV() + 3.0f));
        screen.drawTiledTexturedRect(new Rect2F(xOff + 3.0f, yOff + height - 3.0f, width - 6.0f, 3.0f), new UVData(uvData.getU() + 3.0f, uvData.getV() + 17.0f), new UVData(uvData.getU() + 197.0f, uvData.getV() + 20.0f));
    }

    private void drawMiddle(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        UVData uvData = this.getUvData();
        float xOff = rect.getX();
        float yOff = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        screen.drawTiledTexturedRect(new Rect2F(xOff + 3.0f, yOff + 3.0f, width - 6.0f, height - 6.0f), new UVData(uvData.getU() + 3.0f, uvData.getV() + 3.0f), new UVData(uvData.getU() + 197.0f, uvData.getV() + 17.0f));
    }

    public void addPressListener(IButtonPressListener listener) {
        this.pressListeners.add(listener);
    }

    public void addHoverListener(IButtonHoverListener listener) {
        this.hoverListeners.add(listener);
    }

    public void disable() {
        this.isEnabled = false;
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void hide() {
        this.isVisible = false;
    }

    public void show() {
        this.isVisible = true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void onMousePress(IScreenContext screen, double x, double y, int button) {
        if (button != 0) {
            return;
        }
        Rect2F dimensions = this.getTransformedDimensions(screen);
        if (dimensions.isPointInRect(x, y) && this.canPress()) {
            if (!this.isHovered) {
                this.hoverListeners.forEach(l -> l.onButtonHover(x, y, true));
                this.isHovered = true;
            }
            screen.getMc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.pressListeners.forEach(l -> l.onButtonPress(x, y));
        }
    }

    private boolean canPress() {
        return this.isVisible && this.isEnabled;
    }
}

