/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.element.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tridevmc.compound.ui.ICompoundUI;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.UVData;
import com.tridevmc.compound.ui.element.Element;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.layout.LayoutNone;
import com.tridevmc.compound.ui.screen.IScreenContext;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ElementSlot
extends Element {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/inventory.png");
    private Slot slot;
    private boolean drawOverlay;
    private boolean drawUnderlay;
    private ItemStack displayStack;
    private String displayString;

    public ElementSlot(@Nonnull Rect2F dimensions, @Nonnull Slot slot) {
        this(dimensions, new LayoutNone(), slot);
    }

    public ElementSlot(@Nonnull Rect2F dimensions, @Nonnull ILayout layout, @Nonnull Slot slot) {
        super(dimensions, layout);
        this.slot = slot;
    }

    @Override
    public void drawBackground(ICompoundUI ui) {
        IScreenContext screen = ui.getScreenContext();
        Rect2F rect = this.getTransformedDimensions(screen);
        screen.bindTexture(TEXTURE);
        screen.drawTexturedRect(rect, new UVData(8.0f, 8.0f), new UVData(8.0f, 8.0f));
        screen.drawTexturedRect(new Rect2F(rect.getX(), rect.getY(), rect.getWidth() - 1.0f, 1.0f), new UVData(7.0f, 7.0f), new UVData(7.0f, 7.0f));
        screen.drawTexturedRect(new Rect2F(rect.getX(), rect.getY(), 1.0f, rect.getHeight() - 1.0f), new UVData(7.0f, 7.0f), new UVData(7.0f, 7.0f));
        screen.drawTexturedRect(new Rect2F(rect.getX() + rect.getWidth() - 1.0f, rect.getY() + 1.0f, 1.0f, rect.getHeight() - 1.0f), new UVData(24.0f, 8.0f), new UVData(24.0f, 8.0f));
        screen.drawTexturedRect(new Rect2F(rect.getX() + 1.0f, rect.getY() + rect.getHeight() - 1.0f, rect.getWidth() - 1.0f, 1.0f), new UVData(24.0f, 8.0f), new UVData(24.0f, 8.0f));
    }

    @Override
    public void drawForeground(ICompoundUI ui) {
        if (this.drawUnderlay) {
            this.drawHighlight(ui.getScreenContext());
        }
        Rect2F rect = this.getTransformedDimensions(ui.getScreenContext());
        rect = new Rect2F(rect.getX() + 1.0f, rect.getY() + 1.0f, rect.getWidth() - 2.0f, rect.getHeight() - 2.0f);
        RenderSystem.enableDepthTest();
        ui.getScreenContext().drawItemStack(this.displayStack, rect, this.displayString, 100);
        if (this.drawOverlay) {
            this.drawHighlight(ui.getScreenContext());
        }
    }

    @Override
    public void drawOverlay(ICompoundUI ui) {
        IScreenContext screenContext = ui.getScreenContext();
        if (this.drawOverlay && screenContext.getMc().player.containerMenu.getCarried().isEmpty() && this.slot.hasItem()) {
            this.drawTooltip(ui.getScreenContext());
        }
        this.reset();
    }

    private void drawHighlight(IScreenContext screen) {
        Rect2F highlightArea = this.getTransformedDimensions(screen).offset(new Rect2F(1.0f, 1.0f, -1.0f, -1.0f));
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int slotColor = -2130706433;
        screen.drawRect(highlightArea, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    private void drawTooltip(IScreenContext screen) {
        screen.drawTooltip(screen.getActiveStack(), this.displayStack, (int)screen.getMouseX(), (int)screen.getMouseY());
    }

    private void reset() {
        this.drawOverlay = false;
        this.drawUnderlay = false;
        this.displayStack = this.slot.getItem();
        this.displayString = null;
    }

    public boolean isMouseOverSlot(IScreenContext screen) {
        Rect2F rect = this.getTransformedDimensions(screen).offsetSize(-1.0f, -1.0f);
        return rect.isPointInRect(screen.getMouseX(), screen.getMouseY());
    }

    public void setDrawOverlay(boolean drawOverlay) {
        this.drawOverlay = drawOverlay;
    }

    public void setDisplayStack(ItemStack displayStack) {
        this.displayStack = displayStack;
    }

    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    public void setDrawUnderlay(boolean drawUnderlay) {
        this.drawUnderlay = drawUnderlay;
    }
}

