/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.layout;

import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.element.IElement;
import com.tridevmc.compound.ui.layout.ILayout;
import com.tridevmc.compound.ui.screen.IScreenContext;

public class LayoutMarquee
implements ILayout {
    private long lastTick = -1L;
    private float lastPosition;
    private float currentPosition;
    private float movementSpeed = 1.0f;

    public LayoutMarquee() {
    }

    public LayoutMarquee(float movementSpeed) {
        this.movementSpeed = movementSpeed;
    }

    @Override
    public Rect2F getTransformedRect(IScreenContext screen, IElement element, Rect2F rect) {
        if (screen.getTicks() != this.lastTick) {
            this.lastTick = screen.getTicks();
            this.updatePosition(this.currentPosition + this.movementSpeed);
        }
        if (this.currentPosition > (float)screen.getWidth()) {
            this.currentPosition = -rect.getWidth();
            this.lastPosition = this.currentPosition - this.movementSpeed;
        }
        float x = this.lastPosition + (this.currentPosition - this.lastPosition) * screen.getPartialTicks();
        return rect.setPosition(x, rect.getY());
    }

    private void updatePosition(float newPosition) {
        this.lastPosition = this.currentPosition;
        this.currentPosition = newPosition;
    }
}

