/*
 * Decompiled with CFR 0.152.
 */
package com.tridevmc.compound.ui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tridevmc.compound.ui.EnumUILayer;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.UVData;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public interface IScreenContext {
    public PoseStack getActiveStack();

    public int getWidth();

    public int getHeight();

    public double getMouseX();

    public double getMouseY();

    public float getPartialTicks();

    public long getTicks();

    public Screen getActiveGui();

    public Minecraft getMc();

    public Font getFont();

    public void bindTexture(ResourceLocation var1);

    public void drawRect(Rect2F var1, int var2);

    public void drawGradientRect(Rect2F var1, int var2, int var3);

    default public void drawString(PoseStack matrix, String text, float x, float y, int colour) {
        this.drawText(matrix, (Component)new TextComponent(text).withStyle(s -> s.withColor(colour)), x, y);
    }

    default public void drawCenteredString(PoseStack matrix, String text, float x, float y, int colour) {
        this.drawCenteredText(matrix, (Component)new TextComponent(text).withStyle(s -> s.withColor(colour)), x, y);
    }

    default public void drawStringWithShadow(PoseStack matrix, String text, float x, float y, int colour) {
        this.drawTextWithShadow(matrix, (Component)new TextComponent(text).withStyle(s -> s.withColor(colour)), x, y);
    }

    default public void drawCenteredStringWithShadow(PoseStack matrix, String text, float x, float y, int colour) {
        this.drawCenteredTextWithShadow(matrix, (Component)new TextComponent(text).withStyle(style -> style.withColor(colour)), x, y);
    }

    default public void drawText(PoseStack matrix, Component text, float x, float y) {
        this.drawFormattedCharSequence(matrix, text.getVisualOrderText(), x, y);
    }

    default public void drawCenteredText(PoseStack matrix, Component text, float x, float y) {
        this.drawCenteredFormattedCharSequence(matrix, text.getVisualOrderText(), x, y);
    }

    default public void drawTextWithShadow(PoseStack matrix, Component text, float x, float y) {
        this.drawFormattedCharSequenceWithShadow(matrix, text.getVisualOrderText(), x, y);
    }

    default public void drawCenteredTextWithShadow(PoseStack matrix, Component text, float x, float y) {
        this.drawCenteredFormattedCharSequenceWithShadow(matrix, text.getVisualOrderText(), x, y);
    }

    public void drawFormattedCharSequence(PoseStack var1, FormattedCharSequence var2, float var3, float var4);

    public void drawCenteredFormattedCharSequence(PoseStack var1, FormattedCharSequence var2, float var3, float var4);

    public void drawFormattedCharSequenceWithShadow(PoseStack var1, FormattedCharSequence var2, float var3, float var4);

    public void drawCenteredFormattedCharSequenceWithShadow(PoseStack var1, FormattedCharSequence var2, float var3, float var4);

    public void drawTexturedRect(Rect2F var1, UVData var2);

    public void drawTexturedRect(float var1, float var2, UVData var3, UVData var4);

    public void drawTexturedRect(Rect2F var1, UVData var2, UVData var3);

    public void drawTexturedRect(Rect2F var1, TextureAtlasSprite var2);

    public void drawTexturedRect(Rect2F var1, UVData var2, float var3, float var4);

    public void drawTexturedRect(Rect2F var1, UVData var2, int var3, int var4, float var5, float var6);

    public void drawTiledTexturedRect(Rect2F var1, UVData var2, UVData var3);

    default public void drawTooltip(PoseStack poseStack, ItemStack stack, int x, int y) {
        GuiUtils.preItemToolTip((ItemStack)stack);
        Font font = RenderProperties.get((ItemStack)stack).getFont(stack);
        font = font == null ? this.getFont() : font;
        List tooltip = stack.getTooltipLines((Player)this.getMc().player, (TooltipFlag)(this.getMc().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        this.drawTooltip(poseStack, tooltip, x, y, font);
        GuiUtils.postItemToolTip();
    }

    default public void drawTooltip(PoseStack poseStack, String text, int x, int y) {
        this.drawTooltip(poseStack, (Component)new TextComponent(text), x, y, this.getFont());
    }

    default public void drawTooltip(PoseStack poseStack, String text, int x, int y, Font font) {
        this.drawTooltip(poseStack, (Component)new TextComponent(text), x, y, font);
    }

    default public void drawTooltip(PoseStack poseStack, Component text, int x, int y) {
        this.drawTooltip(poseStack, text, x, y, this.getFont());
    }

    default public void drawTooltip(PoseStack poseStack, Component text, int x, int y, Font font) {
        this.drawTooltip(poseStack, Collections.singletonList(text), x, y, font);
    }

    default public void drawTooltip(PoseStack poseStack, List<Component> lines, int x, int y) {
        this.drawTooltip(poseStack, lines, x, y, this.getFont());
    }

    default public void drawTooltip(PoseStack poseStack, List<Component> lines, int x, int y, Font font) {
        this.drawProcessorAsTooltip(poseStack, Lists.transform(lines, Component::getVisualOrderText), x, y, font);
    }

    default public void drawProcessorAsTooltip(PoseStack poseStack, FormattedCharSequence processor, int x, int y) {
        this.drawProcessorAsTooltip(poseStack, processor, x, y, this.getFont());
    }

    default public void drawProcessorAsTooltip(PoseStack poseStack, FormattedCharSequence processor, int x, int y, Font font) {
        this.drawProcessorAsTooltip(poseStack, Collections.singletonList(processor), x, y, font);
    }

    public void drawProcessorAsTooltip(PoseStack var1, List<FormattedCharSequence> var2, int var3, int var4, Font var5);

    public void drawItemStack(ItemStack var1, Rect2F var2, String var3);

    public void drawItemStack(ItemStack var1, Rect2F var2, String var3, int var4);

    public void drawItemStack(ItemStack var1, int var2, int var3, String var4);

    public void sendChatMessage(String var1);

    public void sendChatMessage(String var1, boolean var2);

    public void openWebLink(URI var1);

    public boolean isShiftDown();

    public boolean isAltDown();

    public float[] getRGBA(int var1);

    public EnumUILayer getCurrentLayer();
}

