/*
 * Copyright 2018 - 2021 TridentMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tridevmc.compound.ui.layout;

import com.google.common.collect.Lists;
import com.tridevmc.compound.ui.Rect2F;
import com.tridevmc.compound.ui.element.IElement;
import com.tridevmc.compound.ui.screen.IScreenContext;

import java.util.List;

/**
 * A layout made up of other layouts, applied in the order they were added.
 */
public class LayoutMulti implements ILayout {

    private List<ILayout> layouts;

    public LayoutMulti(ILayout... layouts) {
        this.layouts = Lists.newArrayList(layouts);
    }

    public void addLayout(ILayout layout) {
        this.layouts.add(layout);
    }

    @Override
    public Rect2F getTransformedRect(IScreenContext screen, IElement element, Rect2F rect) {
        for (ILayout layout : this.layouts) {
            rect = layout.getTransformedRect(screen, element, rect);
        }
        return rect;
    }
}
